/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.jdbc;

import com.techempower.TechEmpowerApplication;
import com.techempower.asynchronous.Asynchronous;
import com.techempower.data.ConnectionMonitor;
import com.techempower.data.DatabaseConnectionListener;
import com.techempower.data.jdbc.JdbcConnectionAttributes;
import com.techempower.data.jdbc.JdbcConnectionProfile;
import com.techempower.helper.NumberHelper;
import com.techempower.log.ComponentLog;
import com.techempower.thread.EndableThread;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class JdbcConnectionManager
implements Asynchronous {
    public static final long POOL_SHRINK_PERIODICITY = 60000L;
    private final JdbcConnectionAttributes attributes;
    private final AtomicInteger callCount = new AtomicInteger(0);
    private final AtomicInteger profileCounter = new AtomicInteger(0);
    private final DatabaseConnectionListener listener;
    private final List<JdbcConnectionProfile> profiles;
    private final ThreadLocal<JdbcConnectionProfile> profilesForThreads;
    private final TechEmpowerApplication application;
    private final ComponentLog log;
    private final JdbcConnectionManagerThread thread;
    private final AtomicInteger profileIndexScanOffset = new AtomicInteger(0);
    private transient long nextCheckSizeTime = System.currentTimeMillis() + 60000L;

    protected JdbcConnectionManager(JdbcConnectionAttributes attributes) {
        this.profiles = new CopyOnWriteArrayList<JdbcConnectionProfile>();
        this.attributes = attributes;
        this.listener = attributes.getListener();
        this.application = attributes.getApplication();
        this.log = attributes.getLog();
        this.thread = new JdbcConnectionManagerThread(this.attributes.getTestInterval() / (long)this.attributes.getMinimumPoolSize());
        this.profilesForThreads = new ThreadLocal();
    }

    @Override
    public void begin() {
        this.thread.start();
    }

    @Override
    public void end() {
        this.thread.end();
        this.dropAllProfiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JdbcConnectionProfile addNewProfile(boolean addWhenFull) {
        JdbcConnectionProfile profile = this.createConnectedProfile();
        if (profile.getConnection() != null) {
            if (this.profiles.size() < this.attributes.getMaximumPoolSize() || addWhenFull) {
                JdbcConnectionManager jdbcConnectionManager = this;
                synchronized (jdbcConnectionManager) {
                    this.profiles.add(profile);
                }
            } else {
                profile.setCloseOnRelease(true);
            }
            return profile;
        }
        return null;
    }

    protected JdbcConnectionProfile getDetachedProfile() {
        return this.createConnectedProfile();
    }

    private void checkSize() {
        JdbcConnectionAttributes connectionAttributes = this.attributes;
        int size = this.profiles.size();
        while (size < connectionAttributes.getMinimumPoolSize() || size > connectionAttributes.getMaximumPoolSize()) {
            if (size < connectionAttributes.getMinimumPoolSize()) {
                if (this.addNewProfile(true) == null) {
                    this.log.log("Cannot establish connection to populate pool.", 70);
                    break;
                }
            } else if (size > connectionAttributes.getMaximumPoolSize()) {
                this.dropProfile();
            }
            size = this.profiles.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactSize() {
        JdbcConnectionAttributes connectionAttributes;
        long now = System.currentTimeMillis();
        int size = this.profiles.size();
        if (size > (connectionAttributes = this.attributes).getMinimumPoolSize() && this.nextCheckSizeTime < now) {
            long staleConnectionTime = System.currentTimeMillis() - connectionAttributes.getStaleTimeout();
            long abortConnectionTime = System.currentTimeMillis() - connectionAttributes.getAbortTimeout();
            ArrayList<JdbcConnectionProfile> profileArray = new ArrayList<JdbcConnectionProfile>(this.profiles);
            JdbcConnectionManager jdbcConnectionManager = this;
            synchronized (jdbcConnectionManager) {
                this.nextCheckSizeTime = now + 60000L;
                for (JdbcConnectionProfile current : profileArray) {
                    if (current.getLastUse() < abortConnectionTime || current.getLastUse() < staleConnectionTime && !current.isInUse()) {
                        current.close(true);
                        this.profiles.remove(current);
                    }
                    if (this.profiles.size() <= connectionAttributes.getMinimumPoolSize()) break;
                }
            }
            if (this.profileIndexScanOffset.get() > 1000000000) {
                this.profileIndexScanOffset.set(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keepAlive(int index) {
        JdbcConnectionProfile profile = null;
        JdbcConnectionManager jdbcConnectionManager = this;
        synchronized (jdbcConnectionManager) {
            if (this.profiles.size() > 0) {
                profile = this.profiles.get(index % this.profiles.size());
            }
        }
        if (profile != null) {
            profile.keepAlive();
        }
    }

    protected JdbcConnectionProfile getProfile() {
        this.callCount.incrementAndGet();
        this.checkSize();
        JdbcConnectionProfile threadProfile = this.profilesForThreads.get();
        if (threadProfile != null && threadProfile.isConnectionAvailable() && threadProfile.claim()) {
            return threadProfile;
        }
        threadProfile = this.getAnyAvailableProfile();
        this.profilesForThreads.set(threadProfile);
        return threadProfile;
    }

    private JdbcConnectionProfile getAnyAvailableProfile() {
        int startingScanCycle;
        JdbcConnectionProfile available = null;
        int size = this.profiles.size();
        int scanIteration = this.profileIndexScanOffset.getAndIncrement();
        int currentScanCycle = startingScanCycle = scanIteration / size;
        while (currentScanCycle - startingScanCycle < 2) {
            int scanIndex = scanIteration % size;
            try {
                JdbcConnectionProfile current = this.profiles.get(scanIndex);
                if (current.claim()) {
                    available = current;
                    break;
                }
            }
            catch (IndexOutOfBoundsException ioobexc) {
                size = this.profiles.size();
            }
            scanIteration = this.profileIndexScanOffset.getAndIncrement();
            currentScanCycle = scanIteration / size;
        }
        if (available == null) {
            available = this.addNewProfile(false);
        }
        if (available.isClosed()) {
            available.establishDatabaseConnection();
        }
        if (available.isClosed()) {
            this.dropProfile(available);
            available = null;
        }
        return available;
    }

    protected ConnectionMonitor getConnectionMonitor() {
        JdbcConnectionProfile profile = this.getProfile();
        if (profile != null) {
            return profile.getMonitor();
        }
        return null;
    }

    protected synchronized void dropProfile() {
        this.dropProfile(this.profiles.size() - 1);
    }

    protected synchronized void dropProfile(int whichProfile) {
        if (whichProfile >= 0 && whichProfile < this.profiles.size()) {
            JdbcConnectionProfile profile = this.profiles.get(whichProfile);
            this.dropProfile(profile);
        }
    }

    protected synchronized void dropProfile(JdbcConnectionProfile profile) {
        if (profile != null) {
            profile.close(true);
            this.profiles.remove(profile);
        }
    }

    protected synchronized void dropAllProfiles() {
        while (this.profiles.size() > 0) {
            this.dropProfile(0);
        }
    }

    public int getCallCount() {
        return this.callCount.get();
    }

    protected JdbcConnectionAttributes getAttributes() {
        return this.attributes;
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    protected JdbcConnectionProfile createConnectedProfile() {
        int newProfileId = this.profileCounter.incrementAndGet();
        JdbcConnectionProfile profile = new JdbcConnectionProfile(newProfileId, this);
        profile.establishDatabaseConnection();
        return profile;
    }

    public synchronized List<JdbcConnectionProfile> getProfiles() {
        return new ArrayList<JdbcConnectionProfile>(this.profiles);
    }

    protected DatabaseConnectionListener getListener() {
        return this.listener;
    }

    class JdbcConnectionManagerThread
    extends EndableThread {
        private int index;

        public JdbcConnectionManagerThread(long sleepInterval) {
            super("JDBC Connection Manager (" + JdbcConnectionManager.this.application.getVersion().getProductName() + ", " + JdbcConnectionManager.this.attributes.getDisplayName() + ")", NumberHelper.boundInteger((int)sleepInterval, 1000, Integer.MAX_VALUE));
            this.index = 0;
        }

        @Override
        public void run() {
            this.log("JDBC Connection Manager thread started (sleep period " + this.getSleepPeriod() + "ms).");
            while (this.checkPause()) {
                this.simpleSleep();
                if (!this.checkPause()) continue;
                JdbcConnectionManager.this.checkSize();
                JdbcConnectionManager.this.compactSize();
                if (!JdbcConnectionManager.this.attributes.isTestEnabled()) continue;
                JdbcConnectionManager.this.keepAlive(this.index++);
            }
            this.log("JDBC Connection Manager thread ending.");
        }

        private void log(String debug) {
            JdbcConnectionManager.this.log.log(debug, 50);
        }
    }
}

