/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.jdbc;

import com.techempower.data.ConnectionMonitor;
import com.techempower.data.jdbc.JdbcConnectionAttributes;
import com.techempower.data.jdbc.JdbcConnectionManager;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.helper.ThreadHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.StringList;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class JdbcConnectionProfile {
    public static final long CLOSE_DELAY = 10000L;
    private static final long UNUSED = -1L;
    private int id = 0;
    private long useCount = 1L;
    private int closeCount = 0;
    private int connectCount = 0;
    private volatile long lastUsed = System.currentTimeMillis();
    private final JdbcConnectionManager manager;
    private final ComponentLog log;
    private volatile Connection connection;
    private boolean closeOnRelease;
    private final AtomicLong reservedForThread = new AtomicLong(-1L);
    private final Monitor connectionMonitor = new Monitor();

    protected JdbcConnectionProfile(int id, JdbcConnectionManager manager) {
        this.manager = manager;
        this.log = manager.getLog();
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    protected void setCloseOnRelease(boolean closeOnRelease) {
        this.closeOnRelease = closeOnRelease;
    }

    protected synchronized void establishDatabaseConnection() {
        this.close();
        if (this.connection == null) {
            ++this.connectCount;
            JdbcConnectionAttributes attributes = this.manager.getAttributes();
            if (attributes != null && StringHelper.isNonEmpty(attributes.getJdbcURLPrefix()) && StringHelper.isNonEmpty(attributes.getConnectString())) {
                String connectionUrl = String.valueOf(attributes.getJdbcURLPrefix()) + attributes.getConnectString();
                try {
                    this.log("Establishing database connection: [" + connectionUrl + ", " + attributes.getUsername() + "]", 0);
                    this.connection = DriverManager.getConnection(connectionUrl, attributes.getUsername(), attributes.getPassword());
                }
                catch (SQLException sqlexc) {
                    this.log("SQL Exception while connecting.", 70, sqlexc);
                    this.connection = null;
                }
            } else {
                this.log("JDBC URL prefix or connect string is empty; cannot connect to database.", 70);
            }
        }
    }

    protected Connection getConnection() {
        if (!this.isConnectionAvailable()) {
            this.establishDatabaseConnection();
        }
        return this.connection;
    }

    protected void log(String string) {
        this.log.log("[c" + this.getId() + ";t" + this.reservedForThread.get() + "] " + string);
    }

    protected void log(String string, int level) {
        this.log.log("[c" + this.getId() + ";t" + this.reservedForThread.get() + "] " + string, level);
    }

    protected void log(String string, int level, Throwable throwable) {
        this.log.log("[c" + this.getId() + ";t" + this.reservedForThread.get() + "] " + string, level, throwable);
    }

    protected void log(String string, Throwable throwable) {
        this.log.log("[c" + this.getId() + ";t" + this.reservedForThread.get() + "] " + string, throwable);
    }

    protected synchronized void keepAlive() {
        final Connection connect = this.connection;
        if (connect != null) {
            if (this.claim(false)) {
                final JdbcConnectionManager mgr = this.manager;
                Runnable keepAlive = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                String query = mgr.getAttributes().getTestQuery();
                                String expectedResult = mgr.getAttributes().getTestValue();
                                Throwable throwable = null;
                                Object var4_6 = null;
                                try (Statement statement = connect.createStatement(1003, 1007);){
                                    Throwable throwable2 = null;
                                    Object var7_11 = null;
                                    try (ResultSet resultSet = statement.executeQuery(query);){
                                        if (resultSet.next()) {
                                            String actualResult = resultSet.getString(1);
                                            if (!expectedResult.equals(actualResult)) {
                                                JdbcConnectionProfile.this.log("Expected \"" + expectedResult + "\" but received \"" + actualResult + "\".", 70);
                                            }
                                        } else {
                                            JdbcConnectionProfile.this.log("No results from keep-alive query.", 70);
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        throw throwable2;
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (SQLException sqlexc) {
                                JdbcConnectionProfile.this.log("SQLException during keep-alive: ", 70, sqlexc);
                                JdbcConnectionProfile.this.close(true);
                                JdbcConnectionProfile.this.release();
                            }
                        }
                        finally {
                            JdbcConnectionProfile.this.release();
                        }
                    }
                };
                try {
                    ThreadHelper.submit(keepAlive);
                }
                catch (RejectedExecutionException rje) {
                    this.log("Cannot keep alive connection: ", rje);
                    this.release();
                }
            } else {
                this.log("Unable to run keep-alive. This is normal if a query is running.", 10);
                long time = System.currentTimeMillis() - this.lastUsed;
                if (time > this.manager.getAttributes().getAbortTimeout()) {
                    this.log("Query timeout.  Stopping query running for " + time + "ms.");
                    this.close(true);
                }
            }
        }
    }

    public boolean isInUse() {
        return this.reservedForThread.get() != -1L;
    }

    protected void notifyListenerOnClaim() {
        if (this.manager.getListener() != null) {
            this.manager.getListener().queryStarting();
        }
    }

    protected void notifyListenerOnRelease() {
        if (this.manager.getListener() != null) {
            this.manager.getListener().queryCompleting();
        }
    }

    public boolean claim() {
        boolean claimed = false;
        try {
            boolean bl = claimed = this.claim(true);
            return bl;
        }
        finally {
            if (claimed) {
                this.notifyListenerOnClaim();
            }
        }
    }

    public boolean claim(boolean trackUsage) {
        long threadId = Thread.currentThread().getId();
        if (this.reservedForThread.compareAndSet(-1L, threadId)) {
            if (trackUsage) {
                this.lastUsed = System.currentTimeMillis();
                ++this.useCount;
            }
            return true;
        }
        return false;
    }

    public void release() {
        boolean close = this.closeOnRelease;
        this.reservedForThread.set(-1L);
        try {
            if (close) {
                this.close();
            }
        }
        finally {
            this.notifyListenerOnRelease();
        }
    }

    public boolean isConnectionAvailable() {
        return this.connection != null;
    }

    public long getLastUse() {
        return this.lastUsed;
    }

    protected JdbcConnectionManager getManager() {
        return this.manager;
    }

    public boolean isClosed() {
        return this.connection == null;
    }

    public boolean isClosed(boolean checkConnection) {
        try {
            if (this.connection != null) {
                if (checkConnection) {
                    return this.connection.isClosed();
                }
                return false;
            }
        }
        catch (SQLException sqlexc) {
            this.log("SQLException while determining connection's closed status.", 70, sqlexc);
        }
        return true;
    }

    protected void close() {
        this.close(false);
    }

    protected synchronized void close(boolean onNewThread) {
        if (this.connection != null) {
            ++this.closeCount;
            Closer closer = new Closer(this.connection);
            if (onNewThread) {
                ThreadHelper.schedule(closer, 10000L, TimeUnit.MILLISECONDS);
            } else {
                closer.run();
            }
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringList attributeList = new StringList("; ");
        JdbcConnectionProfile jdbcConnectionProfile = this;
        synchronized (jdbcConnectionProfile) {
            if (this.isInUse()) {
                attributeList.add("in-use (thread " + this.reservedForThread.get() + ")");
            } else {
                attributeList.add("idle");
            }
        }
        if (this.isClosed()) {
            attributeList.add("CLOSED");
        }
        return "JdbcCP [id: " + this.id + "; " + attributeList + "; uses: " + this.useCount + "; connections: " + this.connectCount + "; closes: " + this.closeCount + (this.lastUsed > 0L ? "; last used " + DateHelper.getHumanDifference(this.lastUsed, 2) + " ago" : "") + "]";
    }

    protected DatabaseMetaData getConnectionMetaData() {
        if (this.connection != null) {
            try {
                return this.connection.getMetaData();
            }
            catch (SQLException exc) {
                this.log("Exception while fetching meta data.", 70, exc);
            }
        }
        return null;
    }

    public ConnectionMonitor getMonitor() {
        return this.connectionMonitor;
    }

    private class Closer
    implements Runnable {
        private final Connection localConnection;

        public Closer(Connection connection) {
            this.localConnection = connection;
        }

        @Override
        public void run() {
            this.debug("Closing connection profile " + JdbcConnectionProfile.this.id + ".");
            try {
                this.localConnection.close();
            }
            catch (SQLException sqlexc) {
                this.debug("SQLException while closing connection: " + sqlexc);
            }
        }

        public void debug(String debug) {
            JdbcConnectionProfile.this.log(debug);
        }
    }

    private class Monitor
    implements ConnectionMonitor {
        private Monitor() {
        }

        @Override
        public Connection getConnection() {
            return JdbcConnectionProfile.this.getConnection();
        }

        @Override
        public void close() {
            JdbcConnectionProfile.this.release();
        }
    }
}

