/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.util;

import com.techempower.data.util.TabularColumn;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class CompositeReflectiveColumn
implements TabularColumn {
    private static final Class<?>[] ARGUMENT_TYPES = new Class[0];
    private static final Object[] ARGUMENTS = new Object[0];
    private final String[] methodNames;
    private final String[] methodFinds;
    private final String[] defaultValues;
    private final String columnHeader;
    private final Method[] methods;
    private boolean initialized = false;
    private String template;

    public CompositeReflectiveColumn(String[] methodNames, String columnName, String[] defaultValues, String template) {
        this.methodNames = (String[])methodNames.clone();
        this.methods = new Method[this.methodNames.length];
        this.methodFinds = new String[this.methodNames.length];
        this.columnHeader = columnName;
        this.defaultValues = (String[])defaultValues.clone();
        this.template = template;
        int i = 0;
        while (i < this.methodFinds.length) {
            this.methodFinds[i] = "{" + this.methodNames[i] + "}";
            ++i;
        }
    }

    public CompositeReflectiveColumn(String columnHeader, String template) {
        ArrayList<String> newMethodNames = new ArrayList<String>();
        ArrayList<String> newDefaultValues = new ArrayList<String>();
        ArrayList<String> newMethodFinds = new ArrayList<String>();
        if (StringHelper.isNonEmpty(template)) {
            int pos = -1;
            do {
                if ((pos = template.indexOf(123, pos + 1)) < 0) continue;
                int endPos = template.indexOf(125, pos);
                String extract = template.substring(pos + 1, endPos);
                newMethodFinds.add("{" + extract + "}");
                if (extract.indexOf(58) >= 0) {
                    String[] split = extract.split(":");
                    newMethodNames.add(split[0]);
                    newDefaultValues.add(split[1]);
                    continue;
                }
                newMethodNames.add(extract);
                newDefaultValues.add("");
            } while (pos >= 0 && pos < template.length());
        }
        this.methodNames = CollectionHelper.toStringArray(newMethodNames);
        this.methods = new Method[this.methodNames.length];
        this.methodFinds = CollectionHelper.toStringArray(newMethodFinds);
        this.columnHeader = columnHeader;
        this.defaultValues = CollectionHelper.toStringArray(newDefaultValues);
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    public String getValue(Object object) {
        String[] values = this.getRawValues(object);
        return StringHelper.replaceSubstrings(this.template, this.methodFinds, values);
    }

    public String[] getRawValues(Object object) {
        if (!this.initialized) {
            this.initialized = true;
            int i = 0;
            try {
                i = 0;
                while (i < this.methodNames.length) {
                    this.methods[i] = object.getClass().getMethod(this.methodNames[i], ARGUMENT_TYPES);
                    ++i;
                }
            }
            catch (NoSuchMethodException exc) {
                throw new IllegalArgumentException("Could not find method " + this.methodNames[i], exc);
            }
        }
        String[] values = new String[this.methods.length];
        int i = 0;
        while (i < values.length) {
            if (this.methods[i] != null) {
                try {
                    Object objValue = this.methods[i].invoke(object, ARGUMENTS);
                    if (objValue instanceof String) {
                        String string = (String)objValue;
                        if (StringHelper.isNonEmpty(string)) {
                            values[i] = NetworkHelper.escapeStringForHtml(string);
                        }
                    } else if (objValue instanceof Integer) {
                        values[i] = "" + (Integer)objValue;
                    } else if (objValue instanceof Long) {
                        values[i] = "" + (Long)objValue;
                    }
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            if (values[i] == null) {
                values[i] = this.defaultValues[i];
            }
            ++i;
        }
        return values;
    }

    @Override
    public String getDisplayName() {
        return this.columnHeader;
    }
}

