/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.util;

import com.techempower.data.util.TabularColumn;
import com.techempower.helper.DateHelper;
import gnu.trove.map.TIntObjectMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;

public class ObjectColumn
implements TabularColumn {
    private static final Class<?>[] PARAMETER_TYPES = new Class[0];
    private static final Object[] PARAMETER_VALUES = new Object[0];
    private final String displayFieldName;
    private final String objectMethodName;
    private final String defaultValue;
    private Method objectMethod;
    private final Object labelFields;

    public ObjectColumn(String displayName, String objectMethodName, String defaultValue, Object labelFields) {
        this.displayFieldName = displayName;
        this.labelFields = labelFields;
        this.objectMethodName = objectMethodName;
        this.defaultValue = defaultValue;
    }

    public ObjectColumn(String displayName, String objectMethodName, String defaultValue) {
        this.displayFieldName = displayName;
        this.objectMethodName = objectMethodName;
        this.defaultValue = defaultValue;
        this.labelFields = null;
    }

    @Override
    public String getValue(Object source) {
        if (this.objectMethod == null) {
            try {
                this.objectMethod = source.getClass().getMethod(this.objectMethodName, PARAMETER_TYPES);
            }
            catch (NoSuchMethodException nsmexc) {
                throw new IllegalArgumentException("Could not find method " + this.objectMethodName, nsmexc);
            }
        }
        try {
            String value;
            if (this.labelFields != null) {
                Integer integerValue = (Integer)this.objectMethod.invoke(source, PARAMETER_VALUES);
                int intValue = integerValue;
                if (this.labelFields instanceof TIntObjectMap) {
                    TIntObjectMap labelFieldsMap = (TIntObjectMap)this.labelFields;
                    value = (String)labelFieldsMap.get(intValue);
                    if (value == null) {
                        value = this.defaultValue;
                    }
                } else {
                    String[] labelFieldsString = (String[])this.labelFields;
                    value = intValue >= 0 && intValue < labelFieldsString.length ? labelFieldsString[intValue] : this.defaultValue;
                }
            } else {
                Object objValue = this.objectMethod.invoke(source, PARAMETER_VALUES);
                value = objValue != null ? (objValue instanceof Date ? DateHelper.STANDARD_TECH_FORMAT.format(objValue) : "" + objValue) : this.defaultValue;
            }
            return value;
        }
        catch (IllegalAccessException iae) {
            return this.defaultValue;
        }
        catch (InvocationTargetException ite) {
            return this.defaultValue;
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayFieldName;
    }
}

