/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.Version;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Infrastructure;
import com.techempower.gemini.UrlRewriter;
import com.techempower.gemini.jsp.ScriptsAndSheets;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.scheduler.Scheduler;
import com.techempower.util.EnhancedProperties;
import java.io.File;
import java.util.Locale;

public class BasicInfrastructure
implements Infrastructure {
    public static final String URL_DIR_SEPARATOR = "/";
    public static final String DEFAULT_URL_PREFIX = "";
    public static final String DEFAULT_HTML_DIR = "/";
    public static final String DEFAULT_CSS_DIR = "/";
    public static final String DEFAULT_JAVASCRIPT_DIR = "/";
    public static final String DEFAULT_JSP_DIR = "/jsp/";
    public static final String DEFAULT_JSP_PHYSICAL_DIR = "/jsp/";
    public static final String DEFAULT_IMAGES_DIR = "/images/";
    public static final String DEFAULT_STYLE_DIR = "/html/";
    public static final String DEFAULT_CACHED_RESPONSE_DIR = "/cachedResponses/";
    public static final String DEFAULT_SERVLET_NAME = "/core/dis";
    public static final String DEFAULT_IDENTITY = "Gemini";
    private final GeminiApplication application;
    private final ComponentLog log;
    private String serverName = "";
    private String standardDomain = "";
    private String secureDomain = "";
    private String htmlFileDirectory = "/";
    private String cssFileDirectory = "/";
    private String jsFileDirectory = "/";
    private String logFileDirectory = "";
    private String jspFileDirectory = "/jsp/";
    private String jspPhysicalDirectory = "/jsp/";
    private String imageFileDirectory = "/images/";
    private String cachedResponseDirectory = "/cachedResponses/";
    private String secureHtmlFileDirectory = null;
    private String secureCssFileDirectory = null;
    private String secureJsFileDirectory = null;
    private String secureImageFileDirectory = null;
    private String servletName = "/core/dis";
    private String urlDirectoryPrefix = "";
    private boolean allowDirectJSPs = false;
    private boolean useURLDirectoryPrefix = false;
    private boolean started = false;
    private boolean useCachedToDiskResponses = false;
    private String identity = "Gemini";
    private ScriptsAndSheets applicationSas;

    public BasicInfrastructure(GeminiApplication application) {
        this.application = application;
        this.log = application.getLog("infr");
        application.addAsynchronous(this);
        application.getConfigurator().addConfigurable(this);
        Scheduler scheduler = application.getScheduler();
        if (scheduler != null) {
            application.getConfigurator().addConfigurable(scheduler);
        }
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.serverName = props.getProperty("ServerName", this.serverName);
        this.standardDomain = props.getProperty("StandardDomain", this.standardDomain);
        this.secureDomain = props.getProperty("SecureDomain", this.secureDomain);
        this.htmlFileDirectory = props.getProperty("HTMLDirectory", this.htmlFileDirectory);
        this.cssFileDirectory = props.getProperty("CSSDirectory", this.cssFileDirectory);
        this.jsFileDirectory = props.getProperty("JavaScriptDirectory", this.jsFileDirectory);
        this.jspFileDirectory = props.getProperty("JSPDirectory", this.jspFileDirectory);
        this.jspPhysicalDirectory = props.getProperty("JSPPhysicalDirectory", this.jspPhysicalDirectory);
        this.imageFileDirectory = props.getProperty("ImageDirectory", this.imageFileDirectory);
        this.cachedResponseDirectory = props.getProperty("CachedResponsesDirectory", this.cachedResponseDirectory);
        this.secureHtmlFileDirectory = props.getProperty("SecureHTMLDirectory");
        this.secureCssFileDirectory = props.getProperty("SecureCSSDirectory");
        this.secureJsFileDirectory = props.getProperty("SecureJavaScriptDirectory");
        this.secureImageFileDirectory = props.getProperty("SecureImageDirectory");
        if (props.getProperty("StyleSheetName") != null) {
            this.log.log("StyleSheetName is deprecated!", 70);
        }
        this.servletName = props.getProperty("ServletURL", this.servletName);
        this.allowDirectJSPs = props.getYesNoProperty("AllowDirectJSPs", false);
        this.useCachedToDiskResponses = props.getYesNoProperty("UseDiskResponseCaching", false);
        this.logFileDirectory = props.getProperty("Log.File.LogDirectory", this.logFileDirectory);
        this.identity = props.getProperty("Identity", this.identity);
        if (!this.htmlFileDirectory.endsWith("/")) {
            this.log.log("HTMLDirectory should end with a trailing slash.", 70);
            this.htmlFileDirectory = String.valueOf(this.htmlFileDirectory) + '/';
        }
        if (!this.cssFileDirectory.endsWith("/")) {
            this.log.log("CSSDirectory should end with a trailing slash.", 70);
            this.cssFileDirectory = String.valueOf(this.cssFileDirectory) + '/';
        }
        if (!this.jsFileDirectory.endsWith("/")) {
            this.log.log("JavaScriptDirectory should end with a trailing slash.", 70);
            this.jsFileDirectory = String.valueOf(this.jsFileDirectory) + '/';
        }
        if (!this.imageFileDirectory.endsWith("/")) {
            this.log.log("ImageDirectory should end with a trailing slash.", 70);
            this.imageFileDirectory = String.valueOf(this.imageFileDirectory) + '/';
        }
        if (!this.jspFileDirectory.endsWith("/")) {
            this.log.log("JSPDirectory should end with a trailing slash.", 70);
            this.jspFileDirectory = String.valueOf(this.jspFileDirectory) + '/';
        }
        if (!this.jspPhysicalDirectory.endsWith(File.separator)) {
            this.log.log("JSPPhysicalDirectory should end with a trailing slash or backslash.", 70);
            this.jspPhysicalDirectory = String.valueOf(this.jspPhysicalDirectory) + File.separator;
        }
        if (this.secureHtmlFileDirectory != null && !this.secureHtmlFileDirectory.endsWith("/")) {
            this.log.log("HTMLDirectory should end with a trailing slash.", 70);
            this.secureHtmlFileDirectory = String.valueOf(this.secureHtmlFileDirectory) + '/';
        }
        if (this.secureCssFileDirectory != null && !this.secureCssFileDirectory.endsWith("/")) {
            this.log.log("CSSDirectory should end with a trailing slash.", 70);
            this.secureCssFileDirectory = String.valueOf(this.secureCssFileDirectory) + '/';
        }
        if (this.secureJsFileDirectory != null && !this.secureJsFileDirectory.endsWith("/")) {
            this.log.log("JavaScriptDirectory should end with a trailing slash.", 70);
            this.secureJsFileDirectory = String.valueOf(this.secureJsFileDirectory) + '/';
        }
        if (this.secureImageFileDirectory != null && !this.secureImageFileDirectory.endsWith("/")) {
            this.log.log("ImageDirectory should end with a trailing slash.", 70);
            this.secureImageFileDirectory = String.valueOf(this.secureImageFileDirectory) + '/';
        }
        if (this.cachedResponseDirectory != null && !this.cachedResponseDirectory.endsWith("/")) {
            this.log.log("CachedResponsesDirectory should end with a trailing slash.", 70);
            this.cachedResponseDirectory = String.valueOf(this.cachedResponseDirectory) + '/';
        }
        if (this.useCachedToDiskResponses) {
            File cachedToDiskDir = new File(this.cachedResponseDirectory);
            if (cachedToDiskDir.exists() || cachedToDiskDir.mkdirs()) {
                this.log.log("CachedToDisk directory: " + this.cachedResponseDirectory);
            } else {
                this.log.log("CachedToDisk directory could not be created (tried " + this.cachedResponseDirectory + ")");
            }
        }
        ScriptsAndSheets newSas = new ScriptsAndSheets(this.application);
        this.configureSas(newSas);
        this.applicationSas = newSas;
        this.customConfigure(props);
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    protected void configureSas(ScriptsAndSheets appSas) {
    }

    public void customConfigure(EnhancedProperties props) {
        this.customConfigure(props, null);
    }

    @Deprecated
    public void customConfigure(EnhancedProperties props, Version version) {
    }

    @Override
    public synchronized void begin() {
        if (!this.started) {
            this.start();
            this.started = true;
        }
    }

    @Override
    public synchronized void end() {
        if (this.started) {
            this.shutdown();
            this.started = false;
        }
    }

    public void start() {
    }

    public void shutdown() {
    }

    protected GeminiApplication getApplication() {
        return this.application;
    }

    @Deprecated
    public Scheduler getScheduler() {
        return this.application.getScheduler();
    }

    public ScriptsAndSheets getSas() {
        return this.applicationSas;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getStandardDomain() {
        return this.standardDomain;
    }

    @Override
    public String getStandardDomain(Context context) {
        return "http://" + context.headers().host();
    }

    @Override
    public String getSecureDomain() {
        return this.secureDomain;
    }

    @Override
    public String getJspDirectory() {
        return this.jspFileDirectory;
    }

    @Override
    public String getJspPhysicalDirectory() {
        return this.jspPhysicalDirectory;
    }

    @Override
    public String getHtmlDirectory() {
        if (this.secureHtmlFileDirectory != null) {
            return this.getHtmlDirectory(Context.get());
        }
        return this.htmlFileDirectory;
    }

    public String getHtmlDirectory(Context context) {
        if (this.secureHtmlFileDirectory != null && context != null && context.getRequest().isSecure()) {
            return this.secureHtmlFileDirectory;
        }
        return this.htmlFileDirectory;
    }

    @Override
    public String getCssDirectory() {
        if (this.secureCssFileDirectory != null) {
            return this.getCssDirectory(Context.get());
        }
        return this.cssFileDirectory;
    }

    @Override
    public String getCssDirectory(Context context) {
        if (this.secureCssFileDirectory != null && context != null && context.getRequest().isSecure()) {
            return this.secureCssFileDirectory;
        }
        return this.cssFileDirectory;
    }

    @Override
    public String getJavaScriptDirectory() {
        if (this.secureJsFileDirectory != null) {
            return this.getJavaScriptDirectory(Context.get());
        }
        return this.jsFileDirectory;
    }

    public String getJavaScriptDirectory(Context context) {
        if (this.secureJsFileDirectory != null && context != null && context.getRequest().isSecure()) {
            return this.secureJsFileDirectory;
        }
        return this.jsFileDirectory;
    }

    @Override
    public String getImageDirectory() {
        if (this.secureImageFileDirectory != null) {
            return this.getImageDirectory(Context.get());
        }
        return this.imageFileDirectory;
    }

    public String getImageDirectory(Context context) {
        if (this.secureImageFileDirectory != null && context != null && context.getRequest().isSecure()) {
            return this.secureImageFileDirectory;
        }
        return this.imageFileDirectory;
    }

    public String getCachedResponseDirectory() {
        return this.cachedResponseDirectory;
    }

    public boolean usesCachedToDiskResponses() {
        return this.useCachedToDiskResponses;
    }

    @Override
    public String getImageUrl(String imageFilename) {
        return String.valueOf(this.getImageDirectory()) + imageFilename;
    }

    @Override
    @Deprecated
    public String getImageURL(String imageFilename) {
        return this.getImageUrl(imageFilename);
    }

    @Override
    public String getImageUrl(String imageFilename, Locale locale) {
        return String.valueOf(this.getImageDirectory()) + locale.getLanguage() + "-" + locale.getCountry() + "/" + imageFilename;
    }

    @Override
    @Deprecated
    public String getImageURL(String imageFilename, Locale locale) {
        return this.getImageUrl(imageFilename, locale);
    }

    public String getImageUrl(String imageFilename, Context context) {
        Locale locale = this.application.getLocaleManager().getLocaleRaw(context);
        if (locale != null) {
            return this.getImageUrl(imageFilename, locale);
        }
        return this.getImageUrl(imageFilename);
    }

    @Deprecated
    public String getImageURL(String imageFilename, Context context) {
        return this.getImageUrl(imageFilename, context);
    }

    @Override
    public String getStyleLink(String styleSheetFilename) {
        return "<link rel=\"STYLESHEET\" type=\"text/css\" href=\"" + this.getCssDirectory() + styleSheetFilename + "\" />";
    }

    @Override
    public String getStyleLink(String styleSheetFilename, String media) {
        return "<link rel=\"STYLESHEET\" type=\"text/css\" " + (StringHelper.isNonEmpty(media) ? "media=\"" + media + "\" " : DEFAULT_URL_PREFIX) + "href=\"" + this.getCssDirectory() + styleSheetFilename + "\" />";
    }

    @Override
    public String getName() {
        return this.servletName;
    }

    @Override
    public String getUrl() {
        return this.getName();
    }

    @Override
    @Deprecated
    public String getURL() {
        return this.getUrl();
    }

    @Override
    public String getStandardUrl() {
        return String.valueOf(this.getStandardDomain()) + this.getUrl();
    }

    @Override
    @Deprecated
    public String getStandardURL() {
        return this.getStandardUrl();
    }

    @Override
    public String getSecureUrl() {
        return String.valueOf(this.getSecureDomain()) + this.getUrl();
    }

    @Override
    @Deprecated
    public String getSecureURL() {
        return this.getSecureUrl();
    }

    @Override
    public String getCmdUrl(String command) {
        UrlRewriter rewriter = this.application.getUrlRewriter();
        if (rewriter.isActive() && rewriter.accept(command)) {
            return rewriter.rewriteURL(command);
        }
        return String.valueOf(this.servletName) + '?' + "cmd" + '=' + command;
    }

    @Override
    @Deprecated
    public String getCmdURL(String command) {
        return this.getCmdUrl(command);
    }

    @Override
    public String getCmdAnchor(String command) {
        return "<a href=\"" + this.getCmdUrl(command) + "\">";
    }

    @Override
    public String getStandardCmdUrl(String command) {
        return String.valueOf(this.getStandardDomain()) + this.getCmdUrl(command);
    }

    @Override
    @Deprecated
    public String getStandardCmdURL(String command) {
        return this.getStandardCmdUrl(command);
    }

    public String getStandardCmdUrl(String command, Context context) {
        return String.valueOf(this.getStandardDomain(context)) + this.getCmdUrl(command);
    }

    @Deprecated
    public String getStandardCmdURL(String command, Context context) {
        return this.getStandardCmdUrl(command, context);
    }

    @Override
    public String getSecureCmdUrl(String command) {
        return String.valueOf(this.getSecureDomain()) + this.getCmdUrl(command);
    }

    @Override
    @Deprecated
    public String getSecureCmdURL(String command) {
        return this.getSecureCmdUrl(command);
    }

    @Override
    public String getURLDirectoryPrefix() {
        return this.urlDirectoryPrefix;
    }

    @Override
    public boolean canInvokeJSPsDirectly() {
        return this.allowDirectJSPs;
    }

    @Override
    public boolean useURLDirectoryPrefix() {
        return this.useURLDirectoryPrefix;
    }

    public String getLogFileDirectory() {
        return this.logFileDirectory;
    }

    @Override
    public String identify() {
        return this.identity;
    }

    public String getSecureHtmlDirectory() {
        if (this.secureHtmlFileDirectory == null) {
            return this.htmlFileDirectory;
        }
        return this.secureHtmlFileDirectory;
    }

    public String getSecureCssDirectory() {
        if (this.secureCssFileDirectory == null) {
            return this.cssFileDirectory;
        }
        return this.secureCssFileDirectory;
    }

    public String getSecureJsDirectory() {
        if (this.secureJsFileDirectory == null) {
            return this.jsFileDirectory;
        }
        return this.secureJsFileDirectory;
    }

    public String getSecureImageDirectory() {
        if (this.secureImageFileDirectory == null) {
            return this.imageFileDirectory;
        }
        return this.secureImageFileDirectory;
    }
}

