/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.LegacyContext;
import com.techempower.gemini.UrlRewriter;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicUrlRewriter
extends UrlRewriter {
    private final ComponentLog log;
    private final Map<String, ArrayList<String>> rules = new HashMap<String, ArrayList<String>>();

    public BasicUrlRewriter(GeminiApplication application) {
        super(application);
        this.log = application.getLog("urlw");
    }

    @Override
    public void configure(EnhancedProperties props) {
        super.configure(props);
        String[] newRules = props.getArrayProperty("UrlRewriter.Rules");
        this.createRules(newRules);
    }

    protected void createRules(String[] configuredRules) {
        this.rules.clear();
        String[] stringArray = configuredRules;
        int n = configuredRules.length;
        int n2 = 0;
        while (n2 < n) {
            String toUse = stringArray[n2];
            this.addRule(toUse, null);
            ++n2;
        }
    }

    @Override
    public void addRule(String rule, String command) {
        String toUse = rule;
        if (toUse.indexOf(47) == 0) {
            toUse = toUse.substring(1);
        }
        String[] split = toUse.split("\\/");
        String cmd = null;
        if (split.length > 0 && split[0] != null && StringHelper.isNonEmptyTrimmed(split[0])) {
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String maybeCommand = stringArray[n2];
                if (this.isCMD(maybeCommand)) {
                    cmd = this.cleanCommand(maybeCommand);
                    this.getRules().put(this.getRuleKey(cmd, split.length), new ArrayList());
                }
                ++n2;
            }
            stringArray = split;
            n = split.length;
            n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                if (this.getRule(this.getRuleKey(cmd, split.length)) != null) {
                    this.getRule(this.getRuleKey(cmd, split.length)).add(parameter.trim());
                }
                ++n2;
            }
        }
    }

    @Override
    public void parseRequest(LegacyContext context) {
        String uri = context.getRequestUri();
        uri = uri.replaceFirst(this.getApplication().getInfrastructure().getUrl(), "");
        String[] split = uri.split("\\/");
        if (this.isActive() && split.length > 0 && StringHelper.isNonEmpty(split[0])) {
            try {
                List<String> rule;
                String cmd = null;
                int commandIndex = 0;
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String maybeCommand = stringArray[n2];
                    if (this.rules.keySet().contains(this.getRuleKey(maybeCommand, split.length))) {
                        context.setRewritten(true);
                        cmd = maybeCommand;
                        context.putRequestValue("cmd", cmd);
                        break;
                    }
                    ++commandIndex;
                    ++n2;
                }
                if (cmd != null && (rule = this.getRule(this.getRuleKey(cmd, split.length))) != null) {
                    int counter = 0;
                    while (counter < split.length) {
                        String value = split[counter];
                        String key = rule.get(counter);
                        if (key != null && counter != commandIndex) {
                            context.putRequestValue(key, value);
                        }
                        ++counter;
                    }
                }
            }
            catch (Exception ex) {
                try {
                    this.log.log("::parseRequest caught exception, probably a malformed url " + uri);
                    context.setRewritten(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean accept(String command) {
        return this.accept(command, new String[0]);
    }

    @Override
    public boolean accept(String command, String paramKey) {
        String[] stringArray;
        if (StringHelper.isEmpty(paramKey)) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = paramKey;
        }
        return this.accept(command, stringArray);
    }

    @Override
    public boolean accept(String command, String[] paramKeys) {
        return this.getRule(this.getRuleKey(command, paramKeys.length + 1)) != null;
    }

    @Override
    public String rewriteURL(String command, String[] paramKeys, String[] paramValues) {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append(this.getApplication().getInfrastructure().getUrl());
        ArrayList<String> keys = new ArrayList<String>(Arrays.asList(paramKeys));
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(paramValues));
        keys.add("cmd");
        values.add(command);
        List<String> rule = this.getRule(this.getRuleKey(command, keys.size()));
        if (rule != null) {
            for (String rulePart : rule) {
                if (this.isCMD(rulePart)) {
                    toReturn.append(command);
                    toReturn.append('/');
                    continue;
                }
                int counter = 0;
                while (counter < keys.size()) {
                    String key = (String)keys.get(counter);
                    if (rulePart.equals(key)) {
                        toReturn.append((String)values.get(counter));
                        toReturn.append('/');
                    }
                    ++counter;
                }
            }
        }
        return toReturn.toString();
    }

    @Override
    public List<String> getRule(String key) {
        return this.getRules().get(key);
    }

    protected String cleanCommand(String cmd) {
        return cmd.replaceAll("\\*", "").trim();
    }

    protected String getRuleKey(String cmd, int urlLength) {
        return String.valueOf(cmd) + urlLength;
    }

    protected boolean isCMD(String toTest) {
        return toTest.indexOf(42) >= 0;
    }

    protected Map<String, ArrayList<String>> getRules() {
        return this.rules;
    }
}

