/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.google.common.io.BaseEncoding;
import com.techempower.gemini.BasicInfrastructure;
import com.techempower.gemini.Dispatcher;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Request;
import com.techempower.gemini.context.Attachments;
import com.techempower.gemini.context.Cookies;
import com.techempower.gemini.context.Delivery;
import com.techempower.gemini.context.Headers;
import com.techempower.gemini.context.Messages;
import com.techempower.gemini.context.Query;
import com.techempower.gemini.context.SessionNamedValues;
import com.techempower.gemini.internationalization.GeminiResources;
import com.techempower.gemini.session.Session;
import com.techempower.log.ComponentLog;
import com.techempower.security.TokenProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class Context {
    public static final String COMPONENT_CODE = "ctxt";
    private static final String SO_TOKEN_PROVIDER = "_token_provider";
    public static final String SO_CONSUMABLE_REQUEST = "_consumable_prior_request";
    private static final ThreadLocal<Context> CONTEXTS_BY_THREAD = new ThreadLocal();
    private static final BaseEncoding TOKEN_ENCODING = BaseEncoding.base32().omitPadding();
    private final GeminiApplication application;
    private final ComponentLog log;
    private final Dispatcher dispatcher;
    private final BasicInfrastructure infrastructure;
    private final long processingStart = System.currentTimeMillis();
    private final Request request;
    private final Request priorRequest;
    private final SessionNamedValues sessionNamedValues;
    private final Messages messages;
    private final Query query;
    private long requestNumber = 0L;
    private GeminiResources resources;
    private Session session;
    private Delivery delivery;
    private Cookies cookies;
    private Attachments files;
    private Headers headers;

    public Context(Request request, GeminiApplication application) {
        this.application = application;
        this.request = request;
        this.dispatcher = application.getDispatcher();
        this.infrastructure = application.getInfrastructure();
        this.log = application.getLog(COMPONENT_CODE);
        this.sessionNamedValues = new SessionNamedValues(this);
        this.messages = new Messages(this);
        CONTEXTS_BY_THREAD.set(this);
        this.request.setAttribute("Context", this);
        this.getSession(false);
        if (this.session().has(SO_CONSUMABLE_REQUEST)) {
            this.priorRequest = (Request)this.session().getObject(SO_CONSUMABLE_REQUEST);
            this.query = new Query(this.priorRequest);
            this.session().remove(SO_CONSUMABLE_REQUEST);
        } else {
            this.priorRequest = null;
            this.query = new Query(request);
        }
        this.setDefaultCharacterSets();
    }

    public static void complete() {
        CONTEXTS_BY_THREAD.set(null);
    }

    public static Context get() {
        return CONTEXTS_BY_THREAD.get();
    }

    public GeminiApplication getApplication() {
        return this.application;
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    public String getClientID() {
        return this.request.getClientID();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getCurrentUri() {
        return this.request.getCurrentURI();
    }

    public <O> O getDelivery(String name) {
        return this.delivery().getObject(name);
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public long getDuration() {
        return System.currentTimeMillis() - this.processingStart;
    }

    public BasicInfrastructure getInfrastructure() {
        return this.infrastructure;
    }

    public Locale getLocale() {
        return this.application.getLocaleManager().getLocale(this);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.request.getOutputStream();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRealPath(String path) {
        return this.request.getRealPath(path);
    }

    public Request getRequest() {
        return this.request;
    }

    public String getRequestMethod() {
        return this.request.getRequestMethod();
    }

    public long getRequestNumber() {
        return this.requestNumber;
    }

    public String getRequestSignature() {
        return this.request.getRequestSignature();
    }

    public String getRequestUri() {
        return this.request.getRequestURI();
    }

    public GeminiResources getResources() {
        if (this.resources == null) {
            this.resources = this.application.getLocaleManager().getResources(this);
        }
        return this.resources;
    }

    public String getSecureUrl() {
        return this.request.encodeURL(this.infrastructure.getSecureUrl());
    }

    public String getUrl() {
        return this.request.encodeURL(this.infrastructure.getName());
    }

    public SessionNamedValues session() {
        return this.sessionNamedValues;
    }

    public Attachments files() {
        if (this.files == null) {
            this.files = new Attachments(this);
        }
        return this.files;
    }

    public Delivery delivery() {
        if (this.delivery == null) {
            this.delivery = new Delivery();
        }
        return this.delivery;
    }

    public Cookies cookies() {
        if (this.cookies == null) {
            this.cookies = new Cookies(this);
        }
        return this.cookies;
    }

    public Headers headers() {
        if (this.headers == null) {
            this.headers = new Headers(this);
        }
        return this.headers;
    }

    public Messages messages() {
        return this.messages;
    }

    public Query query() {
        return this.query;
    }

    public Session getSession(boolean create) {
        if (this.session == null) {
            this.session = this.request.getSession(create);
        }
        return this.session;
    }

    public String getStandardUrl() {
        return this.request.encodeURL(this.infrastructure.getStandardUrl());
    }

    public long getStartTime() {
        return this.processingStart;
    }

    public String getToken() {
        return TOKEN_ENCODING.encode(this.getTokenProvider().next());
    }

    protected TokenProvider getTokenProvider() {
        TokenProvider provider = (TokenProvider)this.session().getObject(SO_TOKEN_PROVIDER);
        if (provider == null) {
            provider = new TokenProvider(100, 16);
            this.session().putObject(SO_TOKEN_PROVIDER, provider);
        }
        return provider;
    }

    public PrintWriter getWriter() throws IOException {
        return this.request.getWriter();
    }

    public boolean isCommitted() {
        return this.request.isCommitted();
    }

    public boolean isNewSession() {
        Session currentSession = this.getSession(false);
        return currentSession == null ? true : currentSession.isNew();
    }

    public boolean isHead() {
        if (this.isPriorRequestBound()) {
            return this.priorRequest.isHead();
        }
        return this.request.isHead();
    }

    public boolean isGet() {
        if (this.isPriorRequestBound()) {
            return this.priorRequest.isGet();
        }
        return this.request.isGet();
    }

    public boolean isPost() {
        if (this.isPriorRequestBound()) {
            return this.priorRequest.isPost();
        }
        return this.request.isPost();
    }

    public boolean isPut() {
        if (this.isPriorRequestBound()) {
            return this.priorRequest.isPut();
        }
        return this.request.isPut();
    }

    public boolean isDelete() {
        if (this.isPriorRequestBound()) {
            return this.priorRequest.isDelete();
        }
        return this.request.isDelete();
    }

    public boolean isTrace() {
        if (this.isPriorRequestBound()) {
            return this.priorRequest.isTrace();
        }
        return this.request.isTrace();
    }

    public boolean isOptions() {
        if (this.isPriorRequestBound()) {
            return this.priorRequest.isOptions();
        }
        return this.request.isOptions();
    }

    public boolean isConnect() {
        if (this.isPriorRequestBound()) {
            return this.priorRequest.isConnect();
        }
        return this.request.isConnect();
    }

    public boolean isPatch() {
        if (this.isPriorRequestBound()) {
            return this.priorRequest.isPatch();
        }
        return this.request.isPatch();
    }

    public boolean isPriorRequestBound() {
        return this.priorRequest != null;
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public void print(String text) {
        try {
            this.request.print(text);
        }
        catch (IOException ioexc) {
            this.log.log("IOException on print().");
        }
    }

    protected void processRenderException(Exception exc, String pageName) {
        this.processRenderException(exc, pageName, "Including " + pageName);
    }

    protected void processRenderException(Exception exc, String pageName, String description) {
        this.log.log("Exception while including " + pageName + ": " + exc);
        this.dispatcher.dispatchException(this, exc, description);
    }

    public boolean redirect(String redirectDestinationUrl) {
        return this.request.redirect(redirectDestinationUrl);
    }

    public boolean redirectPermanent(String redirectDestinationUrl) {
        return this.request.redirectPermanent(redirectDestinationUrl);
    }

    public void sendError(int error) {
        try {
            this.request.sendError(error);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendError(int error, String message) {
        try {
            this.request.sendError(error, message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setContentType(String contentType) {
        this.request.setContentType(contentType);
    }

    public void setDefaultCharacterSets() {
        try {
            this.request.setCharacterEncoding(this.application.getDefaultRequestCharset().displayName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setLocale(Locale locale) {
        this.application.getLocaleManager().setLocale(this, locale);
    }

    public void setLocale(String languageID, String countryID) {
        this.application.getLocaleManager().setLocale(this, languageID, countryID);
    }

    public void setRequestNumber(long requestNumber) {
        this.requestNumber = requestNumber;
    }

    public String toString() {
        return "Context [" + this.getClientID() + "]";
    }

    public boolean validateToken(String name) {
        String token = this.query().get(name);
        return token != null && this.getTokenProvider().validate(TOKEN_ENCODING.decode((CharSequence)token));
    }

    public void setStatus(int status) {
        this.request.setStatus(status);
    }
}

