/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.TechEmpowerApplication;
import com.techempower.cache.EntityStore;
import com.techempower.data.ConnectorFactory;
import com.techempower.data.DatabaseConnectionListener;
import com.techempower.data.DatabaseConnectionListenerList;
import com.techempower.data.DatabaseConnector;
import com.techempower.data.EntityUpdater;
import com.techempower.data.jdbc.BasicConnectorFactory;
import com.techempower.gemini.ApplicationRegistrar;
import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.BasicInfrastructure;
import com.techempower.gemini.BasicUrlRewriter;
import com.techempower.gemini.Configurator;
import com.techempower.gemini.Context;
import com.techempower.gemini.Dispatcher;
import com.techempower.gemini.GeminiApplicationInterface;
import com.techempower.gemini.GeminiConstants;
import com.techempower.gemini.GeminiInstantiationError;
import com.techempower.gemini.InfrastructureServlet;
import com.techempower.gemini.InitConfig;
import com.techempower.gemini.InitializationTask;
import com.techempower.gemini.Request;
import com.techempower.gemini.UrlRewriter;
import com.techempower.gemini.admin.notification.BasicNotification;
import com.techempower.gemini.admin.notification.Notification;
import com.techempower.gemini.admin.notification.Notifier;
import com.techempower.gemini.admin.notification.listener.EmailNotificationListener;
import com.techempower.gemini.cluster.client.ClusterClient;
import com.techempower.gemini.cluster.client.handler.ClientConfigurationHandler;
import com.techempower.gemini.data.BasicConnectorListener;
import com.techempower.gemini.email.EmailTransport;
import com.techempower.gemini.email.inbound.EmailDispatcher;
import com.techempower.gemini.email.outbound.EmailServicer;
import com.techempower.gemini.email.outbound.EmailTemplater;
import com.techempower.gemini.feature.BasicFeatureManager;
import com.techempower.gemini.feature.FeatureManager;
import com.techempower.gemini.internationalization.GeminiLocaleManager;
import com.techempower.gemini.log.GeminiLog;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.mustache.MustacheManager;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.session.HttpSessionManager;
import com.techempower.gemini.simulation.SimSessionManager;
import com.techempower.helper.StringHelper;
import com.techempower.helper.ThrowableHelper;
import com.techempower.js.JavaScriptWriter;
import com.techempower.log.ComponentLog;
import com.techempower.log.Log;
import com.techempower.thread.EndableThread;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public abstract class GeminiApplication
extends TechEmpowerApplication
implements GeminiApplicationInterface,
Configurable {
    public static final String FEATURE_STARTUP_NOTE = "startup-notification";
    private OperationalState state = OperationalState.NEW;
    private final ComponentLog log;
    private InfrastructureServlet servlet;
    private InitConfig servletConfig;
    private final BasicInfrastructure infrastructure;
    private final Configurator configurator;
    private final HttpSessionManager sessionManager;
    private final SimSessionManager simSessionManager;
    private final Dispatcher dispatcher;
    private final ConnectorFactory connectorFactory;
    private final EmailServicer emailServicer;
    private final EmailTemplater emailTemplater;
    private final EmailTransport emailTransport;
    private final EntityStore entityStore;
    private final GeminiLocaleManager localeManager;
    private final DatabaseConnectionListener dbConnListener;
    private final UrlRewriter urlRewriter;
    private final EntityUpdater entityUpdater;
    private InitializationWaitThread iwt;
    private final GeminiMonitor monitor;
    private final PyxisSecurity security;
    private final FeatureManager featureManager;
    private final Notifier notifier;
    private final ClusterClient clusterClient;
    private final JavaScriptWriter standardJsw;
    private final MustacheManager mustacheManager;
    private String testQuery = "SELECT 1 AS Result";
    private String testColumn = "Result";
    private String testValue = "1";
    private String administratorEmail = "";
    private int commandHistorySize = 10;
    private boolean requestCounting = false;
    private long startTime = 0L;
    private long endTime = 0L;
    private final AtomicLong requestNumber = new AtomicLong(0L);
    private String defaultResponseType = "text/html;charset=utf-8";
    private Charset defaultResponseCharset = null;
    private Charset defaultRequestCharset = null;
    private List<InitializationTask> initializationTasks = null;
    private int instanceNumber = 0;

    public GeminiApplication() {
        this.log = this.getLog("gemi");
        try {
            this.configurator = this.constructConfigurator();
            this.featureManager = this.constructFeatureManager();
            this.connectorFactory = this.constructConnectorFactory();
            this.notifier = this.constructNotifier();
            this.monitor = this.constructMonitor();
            this.infrastructure = this.constructInfrastructure();
            this.entityStore = this.constructEntityStore();
            this.security = this.constructSecurity();
            this.emailTemplater = this.constructEmailTemplater();
            this.emailTransport = this.constructEmailTransport();
            this.emailServicer = this.constructEmailServicer();
            this.urlRewriter = this.constructUrlRewriter();
            this.mustacheManager = this.constructMustacheManager();
            this.dispatcher = this.constructDispatcher();
            this.sessionManager = this.constructSessionManager();
            this.simSessionManager = this.constructSimSessionManager();
            this.localeManager = this.constructLocaleManager();
            this.dbConnListener = this.constructDatabaseConnectionListener();
            this.entityUpdater = this.constructEntityUpdater();
            this.clusterClient = this.constructClusterClient();
            this.standardJsw = this.constructJavaScriptWriter();
            this.getFeatureManager().add(FEATURE_STARTUP_NOTE, "Send application start-up notification", true);
            if (this.connectorFactory instanceof Configurable) {
                this.configurator.addConfigurable((Configurable)((Object)this.connectorFactory));
            }
            if (this.dbConnListener != null) {
                this.connectorFactory.setDatabaseConnectionListener(this.dbConnListener);
            }
            this.configurator.addConfigurable(this.urlRewriter);
            this.configurator.addConfigurable(this.entityStore);
            this.configurator.addConfigurable(this.localeManager);
        }
        catch (Exception exc) {
            if (this.log != null) {
                this.log.log("Failed to instantiate application.", 90, exc);
            } else {
                System.out.println("Failed to instantiate application.");
                System.out.println("Exception: " + ThrowableHelper.convertStackTraceToString(exc));
            }
            throw new GeminiInstantiationError("Failed to instantiate application.", exc);
        }
    }

    @Override
    public void configure(EnhancedProperties props) {
        String requestCharsetName;
        if (props.getProperty("StartupMailRecipients") != null) {
            this.log.log("Property \"StartupMailRecipients\" is deprecated.");
        }
        if (props.getProperty("StartupMailAuthor") != null) {
            this.log.log("Property \"StartupMailAuthor\" is deprecated.");
        }
        this.administratorEmail = props.getProperty("AdministratorEmail", this.administratorEmail);
        this.requestCounting = props.getYesNoProperty("RequestCounting", this.requestCounting);
        this.testQuery = props.getProperty("Initialization.TestQuery", this.testQuery);
        this.testColumn = props.getProperty("Initialization.TestColumn", this.testColumn);
        this.testValue = props.getProperty("Initialization.TestValue", this.testValue);
        this.getVersion().setDeploymentDescription(props.getProperty("DeploymentDescription", "Unspecified Deployment"));
        if (props.isDefined("RequestStackSize")) {
            this.commandHistorySize = props.getIntegerProperty("RequestStackSize", this.commandHistorySize);
            this.log.log("Deprecated value in .conf file: RequestStackSize.  Use CommandHistorySize instead.", 70);
        }
        this.commandHistorySize = props.getIntegerProperty("CommandHistorySize", this.commandHistorySize);
        String charsetName = props.getProperty("DefaultCharacterSet");
        String responseCharsetName = props.getProperty("Encoding.ResponseCharset", charsetName = props.getProperty("Encoding.Charset", charsetName));
        if (StringHelper.isNonEmpty(responseCharsetName)) {
            try {
                this.defaultResponseCharset = Charset.forName(responseCharsetName);
            }
            catch (Exception exc) {
                this.log.log("No matching character set for name " + responseCharsetName + "; " + exc);
                this.defaultResponseCharset = null;
            }
        }
        if (StringHelper.isNonEmpty(requestCharsetName = props.getProperty("Encoding.RequestCharset", charsetName))) {
            try {
                this.defaultRequestCharset = Charset.forName(requestCharsetName);
            }
            catch (Exception exc) {
                this.log.log("No matching character set for name " + requestCharsetName + "; " + exc);
                this.defaultRequestCharset = null;
            }
        }
        this.defaultResponseType = props.getProperty("Encoding.ResponseType", this.defaultResponseType);
        this.instanceNumber = props.getIntegerProperty("ApplicationInstanceNumber", this.instanceNumber);
        this.instanceNumber = props.getIntegerProperty("SpawnedInstance", this.instanceNumber);
    }

    protected void initialize(InitConfig config) {
        this.servletConfig = config;
        this.displayBanner();
        this.log.log(String.valueOf(this.getVersion().getAbbreviatedProductName()) + " initializing.");
        this.runInitializationTasks();
        Runnable toRunWhenGood = new Runnable(){

            @Override
            public void run() {
                GeminiApplication.this.postInitialize();
                GeminiApplication.this.begin();
            }
        };
        this.log.log("Evaluating initialization state.");
        if (this.evaluateInitialization()) {
            toRunWhenGood.run();
        } else {
            this.waitForInitialization(toRunWhenGood);
        }
    }

    protected void displayBanner() {
        this.log.log(this.getVersion().getVerboseDescription());
        String javaVm = System.getProperty("java.vm.name", "Unknown");
        String javaVmVersion = System.getProperty("java.vm.version", "?");
        String osName = System.getProperty("os.name", "Unknown");
        String osVersion = System.getProperty("os.version", "?");
        String osArch = System.getProperty("os.arch", "Unknown");
        this.log.log(String.valueOf(javaVm) + " (v" + javaVmVersion + ")");
        this.log.log(String.valueOf(osName) + " (v" + osVersion + "; " + osArch + ")");
        if (this.getServletConfig() != null) {
            this.log.log("Servlet Container: " + this.getServletConfig().getServerInfo());
        }
        this.log.log("JVM memory: " + Runtime.getRuntime().totalMemory() / 0x100000L + "Mb; free: " + Runtime.getRuntime().freeMemory() / 0x100000L + "Mb");
    }

    protected boolean evaluateInitialization() {
        boolean goodState;
        block14: {
            goodState = false;
            if (StringHelper.isNonEmpty(this.testQuery)) {
                this.log.log("Running test query: " + this.testQuery);
                Throwable throwable = null;
                Object var3_4 = null;
                try (DatabaseConnector dbConn = this.getConnectorFactory().getConnector(this.testQuery);){
                    String returnValue;
                    dbConn.setForceNewConnection(true);
                    dbConn.runQuery();
                    if (dbConn.more() && this.testValue.equals(returnValue = dbConn.getField(this.testColumn, ""))) {
                        goodState = true;
                    }
                    break block14;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            goodState = true;
        }
        if (goodState) {
            Iterator<InitializationTask> iter = this.getInitializationTasks();
            while (goodState && iter != null && iter.hasNext()) {
                boolean bl = goodState = goodState && iter.next().isTaskReady(this);
            }
        }
        if (goodState) {
            goodState = this.customEvaluateInitialization();
        }
        return goodState;
    }

    protected boolean customEvaluateInitialization() {
        return true;
    }

    protected void waitForInitialization(Runnable toRunWhenGood) {
        this.log.log("Initialization state is bad.  Starting initialization-wait thread.");
        if (this.iwt != null) {
            this.iwt.setKeepRunning(false);
        }
        this.iwt = new InitializationWaitThread(toRunWhenGood);
        this.iwt.start();
    }

    protected void remediateInitialization(int attemptNumber) {
        this.customRemediateInitialization(attemptNumber);
        Iterator<InitializationTask> iter = this.getInitializationTasks();
        while (iter != null && iter.hasNext()) {
            iter.next().taskRemediate(this, attemptNumber);
        }
    }

    protected void customRemediateInitialization(int attemptNumber) {
    }

    protected void postInitialize() {
        this.state = OperationalState.INITIALIZED;
        if (this.iwt != null) {
            this.iwt.setKeepRunning(false);
        }
        if (this.getConfigurator().isConfigured()) {
            this.log.log(String.valueOf(this.getVersion().getAbbreviatedProductName()) + " (" + this.getVersion().getDeploymentDescription() + ") post-initializing.");
            if (this.getStore() != null) {
                this.log.log("Initializing cache.");
                this.getStore().initialize();
            }
            this.sendStartupNotification();
        }
    }

    public void begin() {
        if (this.getConfigurator().isConfigured()) {
            this.log.log(String.valueOf(this.getVersion().getAbbreviatedProductName()) + " (" + this.getVersion().getDeploymentDescription() + ") starting asynchronous resources.");
            this.state = OperationalState.RUNNING;
            this.endTime = 0L;
            this.startTime = System.currentTimeMillis();
            ApplicationRegistrar.register(this);
            this.startAsynchronousResources();
        }
    }

    public void end() {
        this.log.log(String.valueOf(this.getVersion().getAbbreviatedProductName()) + " (" + this.getVersion().getDeploymentDescription() + ") stopping asynchronous resources.");
        this.state = OperationalState.STOPPED;
        if (this.iwt != null) {
            this.iwt.setKeepRunning(false);
        }
        this.endTime = System.currentTimeMillis();
        this.stopAsynchronousResources();
        ApplicationRegistrar.deregister(this);
    }

    public boolean isRunning() {
        return this.state == OperationalState.RUNNING;
    }

    public OperationalState getState() {
        return this.state;
    }

    protected void registerSelf() {
        ApplicationRegistrar.register(this);
    }

    protected void deregisterSelf() {
        ApplicationRegistrar.deregister(this);
    }

    protected void sendStartupNotification() {
        if (this.getFeatureManager().on(FEATURE_STARTUP_NOTE)) {
            String startupTime = GeminiConstants.GEMINI_DATE_FORMAT.format(new Date());
            BasicNotification n = new BasicNotification("Application", String.valueOf(this.getVersion().getProductName()) + " startup at " + startupTime, String.valueOf(this.getVersion().getAbbreviatedProductName()) + " [" + this.getVersion().getDeploymentDescription() + "]" + " application started at " + startupTime + ".", Notification.Severity.HIGH);
            this.getNotifier().addNotification(n);
        }
    }

    public boolean isRequestCounting() {
        return this.requestCounting;
    }

    public long getUptime() {
        if (this.startTime > 0L) {
            if (this.endTime > 0L) {
                return this.endTime - this.startTime;
            }
            return System.currentTimeMillis() - this.startTime;
        }
        return 0L;
    }

    public void addInitializationTask(InitializationTask task) {
        if (this.initializationTasks == null) {
            this.initializationTasks = new ArrayList<InitializationTask>();
        }
        this.initializationTasks.add(task);
    }

    public Iterator<InitializationTask> getInitializationTasks() {
        if (this.initializationTasks != null) {
            return this.initializationTasks.iterator();
        }
        return null;
    }

    protected void runInitializationTasks() {
        Iterator<InitializationTask> iter = this.getInitializationTasks();
        while (iter != null && iter.hasNext()) {
            iter.next().taskInitialize(this);
        }
    }

    public int getApplicationInstanceNumber() {
        return this.instanceNumber;
    }

    protected BasicInfrastructure constructInfrastructure() {
        return new BasicInfrastructure(this);
    }

    @Override
    protected Log constructLog() {
        return new GeminiLog(this);
    }

    protected Configurator constructConfigurator() {
        return new Configurator(this);
    }

    protected Dispatcher constructDispatcher() {
        return new BasicDispatcher(this);
    }

    protected ConnectorFactory constructConnectorFactory() {
        return new BasicConnectorFactory(this, null);
    }

    protected Notifier constructNotifier() {
        Notifier toReturn = new Notifier(this);
        toReturn.addListener(new EmailNotificationListener(this));
        return toReturn;
    }

    protected ClusterClient constructClusterClient() {
        ClusterClient client = new ClusterClient(this);
        client.addHandler(new ClientConfigurationHandler(this));
        return client;
    }

    protected JavaScriptWriter constructJavaScriptWriter() {
        return JavaScriptWriter.standard();
    }

    protected MustacheManager constructMustacheManager() {
        return new MustacheManager(this);
    }

    protected HttpSessionManager constructSessionManager() {
        return new HttpSessionManager(this);
    }

    protected SimSessionManager constructSimSessionManager() {
        return new SimSessionManager(this);
    }

    protected EmailServicer constructEmailServicer() {
        return new EmailServicer(this);
    }

    protected EmailTransport constructEmailTransport() {
        return new EmailTransport(this);
    }

    protected EmailTemplater constructEmailTemplater() {
        return null;
    }

    protected EntityStore constructEntityStore() {
        return new EntityStore(this, this.getConnectorFactory());
    }

    @Deprecated
    protected final EntityStore constructCacheController() {
        return this.constructEntityStore();
    }

    protected PyxisSecurity constructSecurity() {
        return null;
    }

    protected FeatureManager constructFeatureManager() {
        return new BasicFeatureManager(this);
    }

    protected GeminiLocaleManager constructLocaleManager() {
        return new GeminiLocaleManager(this);
    }

    protected EntityUpdater constructEntityUpdater() {
        return new EntityUpdater(this, this.getConnectorFactory());
    }

    protected GeminiMonitor constructMonitor() {
        return new GeminiMonitor(this);
    }

    protected DatabaseConnectionListener constructDatabaseConnectionListener() {
        return new DatabaseConnectionListenerList(new BasicConnectorListener(this), this.getMonitor().getListener());
    }

    public UrlRewriter constructUrlRewriter() {
        return new BasicUrlRewriter(this);
    }

    @Override
    public Context getContext(Request request) {
        return new Context(request, this);
    }

    @Override
    public BasicInfrastructure getInfrastructure() {
        return this.infrastructure;
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public MustacheManager getMustacheManager() {
        return this.mustacheManager;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public ClusterClient getClusterClient() {
        return this.clusterClient;
    }

    public JavaScriptWriter getJavaScriptWriter() {
        return this.standardJsw;
    }

    @Override
    public Configurator getConfigurator() {
        return this.configurator;
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public PyxisSecurity getSecurity() {
        return this.security;
    }

    @Override
    public ConnectorFactory getConnectorFactory() {
        return this.connectorFactory;
    }

    public EmailDispatcher getEmailDispatcher() {
        return null;
    }

    public GeminiMonitor getMonitor() {
        return this.monitor;
    }

    @Override
    public EmailServicer getEmailServicer() {
        return this.emailServicer;
    }

    @Override
    public EmailTransport getEmailTransport() {
        return this.emailTransport;
    }

    @Override
    public EmailTemplater getEmailTemplater() {
        return this.emailTemplater;
    }

    @Override
    public EntityStore getStore() {
        return this.entityStore;
    }

    @Override
    @Deprecated
    public EntityStore getCache() {
        return this.getStore();
    }

    public String getDefaultResponseType() {
        return this.defaultResponseType;
    }

    public boolean isDefaultResponseCharsetSpecified() {
        return this.defaultResponseCharset != null;
    }

    public Charset getDefaultResponseCharset() {
        return this.defaultResponseCharset == null ? Charset.defaultCharset() : this.defaultResponseCharset;
    }

    public boolean isDefaultRequestCharsetSpecified() {
        return this.defaultRequestCharset != null;
    }

    public Charset getDefaultRequestCharset() {
        return this.defaultRequestCharset == null ? Charset.defaultCharset() : this.defaultRequestCharset;
    }

    @Override
    public GeminiLocaleManager getLocaleManager() {
        return this.localeManager;
    }

    @Override
    public HttpSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public SimSessionManager getSimSessionManager() {
        return this.simSessionManager;
    }

    @Override
    public final String getGeminiVersion() {
        return "1.4.0";
    }

    public InfrastructureServlet getServlet() {
        return this.servlet;
    }

    @Override
    public InitConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletConfigParameter(String name) {
        if (this.getServletConfig() != null) {
            return this.getServletConfig().getInitParameter(name);
        }
        return null;
    }

    public InputStream getResourceAsStream(String filename) {
        if (this.getServletConfig() != null) {
            return this.getServletConfig().getResourceAsStream("WEB-INF/" + filename);
        }
        return null;
    }

    public int getCommandHistorySize() {
        return this.commandHistorySize;
    }

    public String getAdministratorEmail() {
        return this.administratorEmail;
    }

    @Override
    public DatabaseConnectionListener getDatabaseConnectionListener() {
        return this.dbConnListener;
    }

    public long getRequestNumber() {
        return this.requestNumber.get();
    }

    public EntityUpdater getEntityUpdater() {
        return this.entityUpdater;
    }

    public UrlRewriter getUrlRewriter() {
        return this.urlRewriter;
    }

    public String toString() {
        return String.valueOf(this.getVersion().getVerboseDescription()) + " (instance " + this.hashCode() + ")";
    }

    public void setServlet(InfrastructureServlet servlet) {
        this.servlet = servlet;
        if (this.monitor != null && this.monitor.getListener() != null) {
            servlet.addRequestListener(this.monitor.getListener());
        }
    }

    public long incrementRequestCount() {
        return this.requestNumber.incrementAndGet();
    }

    class InitializationWaitThread
    extends EndableThread {
        public static final int INITIALIZATION_WAIT_TIME = 10000;
        private Runnable toRunWhenGood;
        private int attempts;

        public InitializationWaitThread(Runnable toRunWhenGood) {
            super("Initialization Wait Thread", 10000);
            this.attempts = 1;
            this.toRunWhenGood = toRunWhenGood;
        }

        @Override
        public void run() {
            while (this.isRunning()) {
                try {
                    if (this.attempts == 1 || this.attempts % 10 == 0) {
                        GeminiApplication.this.log.log("Waiting for initialization state to be \"good\".  Attempt #" + this.attempts + ".");
                    }
                    this.simpleSleep();
                    GeminiApplication.this.remediateInitialization(this.attempts++);
                    if (!GeminiApplication.this.evaluateInitialization()) continue;
                    GeminiApplication.this.log.log("Initialization state has switched to \"good\".");
                    this.setKeepRunning(false);
                    this.toRunWhenGood.run();
                }
                catch (Exception exc) {
                    GeminiApplication.this.log.log("Exception in InitializationWaitThread:" + exc);
                }
            }
        }
    }

    public static enum OperationalState {
        NEW,
        INITIALIZED,
        RUNNING,
        STOPPED;

    }
}

