/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.gemini.BasicInfrastructure;
import com.techempower.gemini.Cookie;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.HttpCookie;
import com.techempower.gemini.Infrastructure;
import com.techempower.gemini.InitConfig;
import com.techempower.gemini.Request;
import com.techempower.gemini.jsp.StringServletOutputStream;
import com.techempower.gemini.session.HttpSession;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpRequest
implements Request {
    public static final String COMPONENT_CODE = "rqst";
    private final GeminiApplication application;
    private final ComponentLog log;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletContext servletContext;
    private final BasicInfrastructure infrastructure;
    private boolean jspHasBeenIncluded = false;
    private final String method;
    private boolean rewritten = false;
    private Map<String, List<String>> rewrittenParameters = null;

    public HttpRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, GeminiApplication application) {
        this.application = application;
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
        this.infrastructure = this.application.getInfrastructure();
        this.log = this.application.getLog(COMPONENT_CODE);
        this.method = this.request.getMethod();
        response.setContentType(this.application.getDefaultResponseType());
    }

    protected GeminiApplication getApplication() {
        return this.application;
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    @Override
    public HttpServletRequest getRawRequest() {
        return this.request;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public HttpServletResponse getRawResponse() {
        return this.response;
    }

    @Override
    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.response.setCharacterEncoding(encoding);
        this.request.setCharacterEncoding(encoding);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return this.request.getHeaderNames();
    }

    @Override
    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        if (this.rewritten) {
            HashSet<String> allParams = new HashSet<String>();
            allParams.addAll(this.rewrittenParameters.keySet());
            Enumeration name = this.request.getParameterNames();
            while (name.hasMoreElements()) {
                allParams.add((String)name.nextElement());
            }
            return Collections.enumeration(allParams);
        }
        return this.request.getParameterNames();
    }

    @Override
    public String getParameter(String name) {
        if (this.rewritten) {
            List<String> values = this.rewrittenParameters.get(name);
            if (values == null || values.isEmpty()) {
                return this.request.getParameter(name);
            }
            return values.get(0);
        }
        return this.request.getParameter(name);
    }

    @Override
    public void putParameter(String name, String value) {
        if (this.rewrittenParameters == null) {
            this.rewrittenParameters = new HashMap<String, List<String>>();
        }
        if (this.rewrittenParameters.get(name) == null) {
            this.rewrittenParameters.put(name, new ArrayList());
        }
        this.rewrittenParameters.get(name).add(value);
    }

    @Override
    public void removeParameter(String name) {
        if (this.rewrittenParameters != null) {
            this.rewrittenParameters.remove(name);
        }
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this.rewritten) {
            List<String> values = this.rewrittenParameters.get(name);
            if (values == null) {
                return this.request.getParameterValues(name);
            }
            return values.toArray(new String[values.size()]);
        }
        return this.request.getParameterValues(name);
    }

    public Map<String, String> getAllRequestParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();
            map.put(name, this.request.getParameter(name));
        }
        return map;
    }

    public String getAllRequestParametersKey() {
        return this.getAllRequestParametersKey(null);
    }

    public String getAllRequestParametersKey(String[] expectedParams) {
        TreeMap<String, String> params = new TreeMap<String, String>(this.getAllRequestParameters());
        StringBuilder sb = new StringBuilder();
        if (expectedParams == null) {
            for (Map.Entry e : params.entrySet()) {
                sb.append((String)e.getKey());
                sb.append("=");
                sb.append((String)e.getValue());
                sb.append("|");
            }
        } else {
            String[] stringArray = expectedParams;
            int n = expectedParams.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                for (Map.Entry e : params.entrySet()) {
                    if (!((String)e.getKey()).startsWith(s)) continue;
                    sb.append((String)e.getKey());
                    sb.append("=");
                    sb.append((String)e.getValue());
                    sb.append("|");
                }
                ++n2;
            }
        }
        return sb.toString();
    }

    @Override
    public void removeAllRequestValues() {
        if (this.rewrittenParameters != null) {
            this.rewrittenParameters.clear();
        }
    }

    @Override
    public String encodeURL(String url) {
        return this.response.encodeURL(url);
    }

    @Override
    public void print(String text) throws IOException {
        this.response.getWriter().println(text);
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return this.response.getWriter();
    }

    @Override
    public String getRequestSignature() {
        Object forwardURI = this.request.getAttribute("javax.servlet.forward.request_uri");
        if (forwardURI == null) {
            String queryString = this.request.getQueryString();
            if (StringHelper.isNonEmpty(queryString)) {
                return this.request.getRequestURL() + "?" + queryString;
            }
            return this.request.getRequestURL().toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.request.getScheme());
        sb.append("://");
        sb.append(this.request.getServerName());
        int port = this.request.getServerPort();
        if (port > 0 && port != 80 && port != 443) {
            sb.append(":");
            sb.append(port);
        }
        sb.append(forwardURI);
        Object forwardQueryString = this.request.getAttribute("javax.servlet.forward.query_string");
        if (forwardQueryString != null) {
            sb.append("?");
            sb.append(forwardQueryString);
        }
        return sb.toString();
    }

    @Override
    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    @Override
    public String getContextPath() {
        return this.request.getContextPath();
    }

    @Override
    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    @Override
    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    @Override
    public <C extends Cookie> C getCookie(String name) {
        HttpCookie returnedCookie = null;
        javax.servlet.http.Cookie[] theCookies = this.request.getCookies();
        if (theCookies != null) {
            int i = 0;
            while (i < theCookies.length) {
                if (theCookies[i].getName().equals(name)) {
                    returnedCookie = new HttpCookie(theCookies[i]);
                    break;
                }
                ++i;
            }
        }
        return (C)returnedCookie;
    }

    @Override
    public void setCookie(String name, String value, String path, int age, boolean secure) {
        javax.servlet.http.Cookie targetCookie = new javax.servlet.http.Cookie(name, value);
        if (StringHelper.isNonEmpty(path)) {
            targetCookie.setPath(path);
        }
        targetCookie.setSecure(secure);
        targetCookie.setMaxAge(age);
        this.response.addCookie(targetCookie);
    }

    @Override
    public void deleteCookie(String name, String path) {
        javax.servlet.http.Cookie deleteCookie = new javax.servlet.http.Cookie(name, "");
        if (StringHelper.isNonEmpty(path)) {
            deleteCookie.setPath(path);
        }
        deleteCookie.setMaxAge(0);
        this.response.addCookie(deleteCookie);
    }

    @Override
    public String getClientID() {
        return this.request.getRemoteAddr();
    }

    @Override
    public String getRequestMethod() {
        return this.request.getMethod();
    }

    @Override
    public boolean redirect(String redirectDestinationUrl) {
        try {
            this.response.sendRedirect(redirectDestinationUrl);
            return true;
        }
        catch (IOException ioexc) {
            return false;
        }
    }

    @Override
    public boolean redirectPermanent(String redirectDestinationUrl) {
        try {
            this.setResponseHeader("Location", redirectDestinationUrl);
            this.response.sendError(301);
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    @Override
    public void setResponseHeader(String headerName, String value) {
        this.response.setHeader(headerName, value);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    @Override
    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    @Override
    public boolean render(String pageName, boolean fullyQualified) throws Exception {
        return this.forwardToJsp(pageName, fullyQualified);
    }

    @Override
    public String renderToString(String path) {
        return StringServletOutputStream.invokeToString(path, this);
    }

    protected boolean forwardToJsp(String pageName, boolean fullyQualified) throws ServletException, IOException {
        String path = "";
        path = fullyQualified ? pageName : String.valueOf(this.infrastructure.getJspDirectory()) + pageName;
        this.servletContext.getRequestDispatcher(path).forward((ServletRequest)this.request, (ServletResponse)this.response);
        this.jspHasBeenIncluded = true;
        return true;
    }

    @Override
    public void setExpiration(int secondsFromNow) {
        this.response.setDateHeader("Expires", System.currentTimeMillis() + (long)secondsFromNow * 1000L);
    }

    @Override
    public String getCurrentURI() {
        return this.request.getRequestURI();
    }

    @Override
    public boolean isSecure() {
        return this.request.isSecure();
    }

    public boolean hasJspBeenIncluded() {
        return this.jspHasBeenIncluded;
    }

    @Override
    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    @Override
    public void sendError(int error) throws IOException {
        this.response.sendError(error);
    }

    @Override
    public void sendError(int error, String message) throws IOException {
        this.response.sendError(error, message);
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public HttpSession getSession(boolean create) {
        return this.application.getSessionManager().getSession(this.request, create);
    }

    @Override
    public void setAttribute(String name, Object o) {
        this.request.setAttribute(name, o);
    }

    @Override
    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    @Override
    public Infrastructure getInfrastructure() {
        return this.infrastructure;
    }

    @Override
    public boolean isHead() {
        return StringHelper.equalsIgnoreCase(this.method, "HEAD");
    }

    @Override
    public boolean isGet() {
        return StringHelper.equalsIgnoreCase(this.method, "GET");
    }

    @Override
    public boolean isPost() {
        return StringHelper.equalsIgnoreCase(this.method, "POST");
    }

    @Override
    public boolean isPut() {
        return StringHelper.equalsIgnoreCase(this.method, "PUT");
    }

    @Override
    public boolean isDelete() {
        return StringHelper.equalsIgnoreCase(this.method, "DELETE");
    }

    @Override
    public boolean isTrace() {
        return StringHelper.equalsIgnoreCase(this.method, "TRACE");
    }

    @Override
    public boolean isOptions() {
        return StringHelper.equalsIgnoreCase(this.method, "OPTIONS");
    }

    @Override
    public boolean isConnect() {
        return StringHelper.equalsIgnoreCase(this.method, "CONNECT");
    }

    @Override
    public boolean isPatch() {
        return StringHelper.equalsIgnoreCase(this.method, "PATCH");
    }

    @Override
    public void setRewritten(boolean rewritten) {
        this.rewritten = rewritten;
        if (rewritten && this.rewrittenParameters == null) {
            this.rewrittenParameters = new HashMap<String, List<String>>();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean includeFile(File file, String fileName, boolean asAttachment, String contentType) {
        boolean setContentType = false;
        InitConfig servletConfig = this.application.getServletConfig();
        if (servletConfig != null) {
            if (StringHelper.isNonEmpty(contentType)) {
                this.setContentType(contentType);
                setContentType = true;
            } else {
                String mimeType = servletConfig.getMimeType(fileName);
                if (mimeType != null) {
                    this.setContentType(mimeType);
                    setContentType = true;
                }
            }
        }
        if (!setContentType) {
            this.setContentType("application/octet-stream;name=\"" + fileName + "\"");
        }
        if (asAttachment) {
            this.setResponseHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
        }
        byte[] buffer = new byte[4096];
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try {
                FileInputStream fis = new FileInputStream(file);
                try {
                    try (OutputStream os = this.getOutputStream();){
                        while (fis.available() > 0) {
                            int read = fis.read(buffer);
                            os.write(buffer, 0, read);
                        }
                    }
                    if (fis == null) return true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return true;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.log("IOException while including file.", 50, e);
            return false;
        }
    }

    @Override
    public void setStatus(int status) {
        this.response.setStatus(status);
    }
}

