/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Request;
import com.techempower.gemini.UrlRewriter;
import com.techempower.gemini.session.Session;
import com.techempower.helper.NetworkHelper;
import com.techempower.js.JavaScriptWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LegacyContext
extends Context {
    public static final String PARAM_DO_NOT_USE_CACHED_RESPONSE = "no-cached";
    public static final String PARAM_FORCE_CACHING = "force-caching";
    private String command;
    private String referencedRender = null;
    private int dispatches = 0;
    private String lastHandler = null;
    private String priorURL;

    public LegacyContext(Request request, GeminiApplication application) {
        super(request, application);
        if (this.getApplication().getUrlRewriter().isActive()) {
            this.getApplication().getUrlRewriter().parseRequest(this);
        }
    }

    public void bindPriorURL(String sessionValueName, boolean removeFromSession) {
        String urlFromSession = this.session().get(sessionValueName);
        if (urlFromSession != null) {
            this.setPriorURL(urlFromSession);
            if (removeFromSession) {
                this.session().remove(sessionValueName);
            }
        }
    }

    public String getPriorURL() {
        return this.priorURL;
    }

    public void setPriorURL(String url) {
        this.priorURL = url;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setReferencedRender(String pageName) {
        this.referencedRender = pageName;
    }

    public boolean render(String pageName) {
        return this.render(pageName, false);
    }

    public boolean render(String pageName, boolean fullyQualified) {
        return this.render(pageName, fullyQualified, null);
    }

    public boolean render(String pageName, boolean fullyQualified, String contentType) {
        this.getDispatcher().renderStarting(this, pageName);
        if (this.referencedRender == null) {
            this.referencedRender = pageName;
        }
        try {
            try {
                if (contentType != null) {
                    this.setContentType(contentType);
                }
                this.getRequest().render(pageName, fullyQualified);
            }
            catch (Exception exc) {
                this.processRenderException(exc, pageName);
                this.getDispatcher().renderComplete(this);
            }
        }
        finally {
            this.getDispatcher().renderComplete(this);
        }
        return true;
    }

    public void setExpiration(int secondsFromNow) {
        this.headers().expires(secondsFromNow);
    }

    public void putRequestValue(String name, String value) {
        this.getRequest().putParameter(name, value);
    }

    @Deprecated
    public Enumeration<String> getParameterNames() {
        return this.getRequest().getParameterNames();
    }

    @Deprecated
    public Object getAttribute(String name) {
        return this.getRequest().getAttribute(name);
    }

    @Deprecated
    public void setAttribute(String name, Object value) {
        this.getRequest().setAttribute(name, value);
    }

    @Deprecated
    public String getCurrentURI() {
        return this.getCurrentUri();
    }

    @Deprecated
    public String getStandardURL() {
        return this.getStandardUrl();
    }

    @Deprecated
    public String getURL() {
        return this.getUrl();
    }

    @Deprecated
    public String getSecureURL() {
        return this.getSecureUrl();
    }

    @Deprecated
    public String getDeliveriesJson(JavaScriptWriter jsw) {
        return jsw != null ? jsw.write(this.delivery().getMap()) : this.getApplication().getJavaScriptWriter().write(this.delivery().getMap());
    }

    @Deprecated
    public String getDeliveriesJson() {
        return this.getDeliveriesJson(null);
    }

    @Deprecated
    public Map<String, Object> getAllDeliveries() {
        return this.delivery().getMap();
    }

    @Deprecated
    public boolean getBooleanRequestValue(String name, boolean defaultValue) {
        return this.query().getBoolean(name, defaultValue);
    }

    @Deprecated
    public boolean getBooleanRequestValue(String name, boolean defaultValue, boolean strict) {
        if (strict) {
            return this.query().getBoolean(name, defaultValue);
        }
        return this.query().getBooleanLenient(name, defaultValue);
    }

    @Deprecated
    public double getDoubleRequestValue(String name) {
        return this.query().getDouble(name);
    }

    @Deprecated
    public double getDoubleRequestValue(String name, double defaultValue) {
        return this.query().getDouble(name, defaultValue);
    }

    @Deprecated
    public <O extends Enum<O>> O getEnumRequestValue(String name, Class<O> type) {
        return this.query().getEnum(name, type);
    }

    @Deprecated
    public int getIntRequestValue(String name) {
        return this.query().getInt(name);
    }

    @Deprecated
    public int getIntRequestValue(String name, int defaultValue) {
        return this.query().getInt(name, defaultValue);
    }

    @Deprecated
    public int getIntRequestValue(String name, int defaultValue, int lowerBound, int upperBound) {
        return this.query().getInt(name, defaultValue, lowerBound, upperBound);
    }

    @Deprecated
    public int[] getIntRequestValues(String name) {
        return this.query().getInts(name);
    }

    @Deprecated
    public long getLongRequestValue(String name) {
        return this.query().getLong(name);
    }

    @Deprecated
    public long getLongRequestValue(String name, long defaultValue) {
        return this.query().getLong(name, defaultValue);
    }

    @Deprecated
    public String getRequestValue(String name, String defaultValue) {
        return this.query().get(name, defaultValue);
    }

    @Deprecated
    public String[] getRequestValues(String name) {
        return this.query().getStrings(name);
    }

    @Deprecated
    public void setCookie(String name, String value) {
        this.setCookie(name, value, this.getInfrastructure().getUrl(), 2592000);
    }

    @Deprecated
    public void setCookie(String name, String value, boolean secure) {
        this.setCookie(name, value, this.getInfrastructure().getUrl(), 2592000, secure);
    }

    @Deprecated
    public void setCookie(String name, String value, int age) {
        this.setCookie(name, value, this.getInfrastructure().getURL(), age);
    }

    @Deprecated
    public void setCookie(String name, String value, String path) {
        this.setCookie(name, value, path, 2592000);
    }

    @Deprecated
    public void setCookie(String name, String value, String path, int age) {
        this.setCookie(name, value, path, age, false);
    }

    @Deprecated
    public void setCookie(String name, String value, String path, int age, boolean secure) {
        this.getRequest().setCookie(name, value, path, age, secure);
    }

    public boolean useDiskResponseCaching() {
        boolean toReturn = !this.getInfrastructure().usesCachedToDiskResponses();
        String value = this.query().get(PARAM_DO_NOT_USE_CACHED_RESPONSE);
        if (value != null) {
            toReturn = Boolean.valueOf(value);
        }
        return !toReturn;
    }

    public void setRewritten(boolean rewritten) {
        this.getRequest().setRewritten(rewritten);
    }

    public boolean sendSecureCMDRedirect(String cmd) {
        return this.redirect(String.valueOf(this.getInfrastructure().getSecureDomain()) + this.getInfrastructure().getCmdUrl(cmd));
    }

    public void setLastHandler(String handlerName) {
        this.lastHandler = handlerName;
    }

    public void printException(Throwable throwable) {
        try {
            throwable.printStackTrace(this.getRequest().getWriter());
        }
        catch (IOException ioexc) {
            this.getLog().log("Exception while attempting to print exception to Context:\n" + ioexc);
        }
    }

    public boolean includeFile(File file, String fileName, boolean asAttachment) {
        return this.includeFile(file, fileName, asAttachment, null);
    }

    public boolean includeFile(File file, String fileName, boolean asAttachment, String contentType) {
        return this.getRequest().includeFile(file, fileName, asAttachment, contentType);
    }

    public boolean includeFile(String fileName, boolean asAttachment) {
        File file = new File(fileName);
        return this.includeFile(file, fileName, asAttachment, null);
    }

    public boolean includeFile(String fileName, boolean asAttachment, String contentType) {
        File file = new File(fileName);
        return this.includeFile(file, fileName, asAttachment, contentType);
    }

    @Deprecated
    public String getLastHandler() {
        if (this.lastHandler != null) {
            return this.lastHandler;
        }
        return "none";
    }

    public int getDispatches() {
        return this.dispatches;
    }

    public void incrementDispatches() {
        ++this.dispatches;
    }

    public String getStandardCmdURL(String commandString) {
        return this.getRequest().encodeURL(this.getInfrastructure().getStandardCmdUrl(commandString));
    }

    public String getStandardCmdURL(String commandString, String paramKey, boolean paramValue) {
        return this.getStandardCmdURL(commandString, paramKey, Boolean.toString(paramValue));
    }

    public String getStandardCmdURL(String commandString, String paramKey, int paramValue) {
        return this.getStandardCmdURL(commandString, paramKey, Integer.toString(paramValue));
    }

    public String getStandardCmdURL(String commandString, String paramKey, String paramValue) {
        return this.getStandardCmdURL(commandString, new String[]{paramKey}, new String[]{paramValue});
    }

    public String getStandardCmdURL(String commandString, String[] paramKeys, String[] paramValues) {
        return String.valueOf(this.getInfrastructure().getStandardDomain()) + this.getCmdURL(commandString, paramKeys, paramValues);
    }

    public String getSecureCmdURL(String commandString) {
        return this.getRequest().encodeURL(this.getInfrastructure().getSecureCmdUrl(commandString));
    }

    public String getSecureCmdURL(String commandString, String paramKey, boolean paramValue) {
        return this.getSecureCmdURL(commandString, paramKey, Boolean.toString(paramValue));
    }

    public String getSecureCmdURL(String commandString, String paramKey, int paramValue) {
        return this.getSecureCmdURL(commandString, paramKey, Integer.toString(paramValue));
    }

    public String getSecureCmdURL(String commandString, String paramKey, String paramValue) {
        return this.getSecureCmdURL(commandString, new String[]{paramKey}, new String[]{paramValue});
    }

    public String getSecureCmdURL(String commandString, String[] paramKeys, String[] paramValues) {
        return String.valueOf(this.getInfrastructure().getSecureDomain()) + this.getCmdURL(commandString, paramKeys, paramValues);
    }

    public String getCmdAnchor(String commandString) {
        return "<a href=\"" + this.getCmdURL(commandString) + "\">";
    }

    public String getCmdURL(String commandString) {
        return this.getRequest().encodeURL(this.getInfrastructure().getCmdUrl(commandString));
    }

    public String getCmdURL(String commandString, String paramKey, boolean paramValue) {
        return this.getCmdURL(commandString, paramKey, Boolean.toString(paramValue));
    }

    public String getCmdURL(String commandString, String paramKey, int paramValue) {
        return this.getCmdURL(commandString, paramKey, Integer.toString(paramValue));
    }

    public String getCmdURL(String commandString, String paramKey, String paramValue) {
        return this.getCmdURL(commandString, new String[]{paramKey}, new String[]{paramValue});
    }

    public String getCmdURL(String commandString, String[] paramKeys, String[] paramValues) {
        StringBuilder sb = new StringBuilder();
        UrlRewriter rewriter = this.getApplication().getUrlRewriter();
        if (rewriter.isActive() && rewriter.accept(commandString, paramKeys)) {
            sb.append(rewriter.rewriteURL(commandString, paramKeys, paramValues));
        } else {
            sb.append(this.getInfrastructure().getCmdUrl(commandString));
            if (sb.length() > 0) {
                sb.append(sb.indexOf("?") >= 0 ? "&" : "?");
            }
            sb.append(NetworkHelper.getQueryString(paramKeys, paramValues));
        }
        return this.getRequest().encodeURL(sb.toString());
    }

    public String getRequestSignatureFull() {
        return this.getRequest().getRequestURL() + this.getAllRequestParametersString();
    }

    public boolean cacheThenRender(String page) {
        return this.cacheThenRender(page, null);
    }

    public boolean cacheThenRender(String page, String[] expectedParams) {
        String responseText = this.getRequest().renderToString(page);
        String key = expectedParams != null ? this.getAllRequestParametersKey(expectedParams) : this.getAllRequestParametersKey();
        this.getApplication().getStore().setCachedResponse(key, responseText);
        this.getLog().log("Caching response for key: " + key + ", referrer: " + this.headers().referrer(), 10);
        return this.respondWithText(responseText);
    }

    public boolean cacheToDiskThenRender(String page) {
        return this.cacheToDiskThenRender(page, null);
    }

    public boolean cacheToDiskThenRender(String page, String[] expectedParams) {
        long invocationTimeInMillis = System.currentTimeMillis();
        String responseText = this.getRequest().renderToString(page);
        invocationTimeInMillis = System.currentTimeMillis() - invocationTimeInMillis;
        this.getLog().log("cacheToDiskThenIncludeJsp took " + invocationTimeInMillis + "ms to invoke '" + page + "' to string.", 10);
        String key = expectedParams != null ? this.getAllRequestParametersKey(expectedParams) : this.getAllRequestParametersKey();
        this.getApplication().getStore().setCachedResponseOnDisk(key, responseText);
        return this.respondWithText(responseText);
    }

    public boolean forceCaching() {
        boolean notCacheResponse = false;
        boolean forceCache = false;
        String value = this.query().get(PARAM_DO_NOT_USE_CACHED_RESPONSE);
        if (value != null) {
            notCacheResponse = Boolean.valueOf(value);
        }
        if ((value = this.query().get(PARAM_FORCE_CACHING)) != null) {
            forceCache = Boolean.valueOf(value);
        }
        return notCacheResponse && forceCache;
    }

    public boolean respondFromCache() {
        return this.respondFromCache(null);
    }

    public boolean respondFromCache(String[] expectedParams) {
        String cachedResponse = this.getApplication().getStore().getCachedResponse(this.getAllRequestParametersKey(expectedParams));
        if (cachedResponse != null) {
            this.getLog().log("Using cached response.", 10);
            return this.respondWithText(cachedResponse);
        }
        return false;
    }

    public boolean respondFromCacheOnDisk() {
        return this.respondFromCacheOnDisk(null);
    }

    public boolean respondFromCacheOnDisk(String[] expectedParams) {
        String cachedResponse = this.getApplication().getStore().getCachedResponseOnDisk(this.getAllRequestParametersKey(expectedParams));
        if (cachedResponse != null) {
            return this.respondWithText(cachedResponse);
        }
        return false;
    }

    protected boolean respondWithText(String responseText) {
        if (responseText != null) {
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter(this.getOutputStream());
                osw.write(responseText);
                return true;
            }
            catch (Exception exc) {
                this.getLog().log("::respondWithText caught exception ", exc);
            }
            finally {
                if (osw != null) {
                    try {
                        osw.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }

    public String encodeURL(String originalURL) {
        return this.getRequest().encodeURL(originalURL);
    }

    public List<String> getAllRequestHeadersForDisplay() {
        return this.getAllRequestHeadersForDisplay(" = ");
    }

    public List<String> getAllRequestHeadersForDisplay(String separator) {
        ArrayList<String> headerStrings = new ArrayList<String>();
        Enumeration<String> enumeration = this.getRequest().getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();
            headerStrings.add(String.valueOf(name) + separator + this.getRequest().getHeader(name));
        }
        return headerStrings;
    }

    public Map<String, String> getAllRequestParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();
            map.put(name, this.getRequest().getParameter(name));
        }
        return map;
    }

    public List<String> getAllRequestParametersForDisplay() {
        ArrayList<String> parmStrings = new ArrayList<String>();
        Enumeration<String> enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();
            parmStrings.add(String.valueOf(name) + " = " + this.getRequest().getParameter(name));
        }
        return parmStrings;
    }

    public String getAllRequestParametersKey() {
        return this.getAllRequestParametersKey(null);
    }

    public String getAllRequestParametersKey(String[] expectedParams) {
        TreeMap<String, String> params = new TreeMap<String, String>(this.getAllRequestParameters());
        StringBuilder sb = new StringBuilder();
        if (expectedParams == null) {
            for (Map.Entry e : params.entrySet()) {
                sb.append((String)e.getKey());
                sb.append("=");
                sb.append((String)e.getValue());
                sb.append("|");
            }
        } else {
            String[] stringArray = expectedParams;
            int n = expectedParams.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                for (Map.Entry e : params.entrySet()) {
                    if (!((String)e.getKey()).startsWith(s)) continue;
                    sb.append((String)e.getKey());
                    sb.append("=");
                    sb.append((String)e.getValue());
                    sb.append("|");
                }
                ++n2;
            }
        }
        return sb.toString();
    }

    public String getAllRequestParametersString() {
        StringBuilder buffer = new StringBuilder();
        Enumeration<String> enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            if (buffer.length() > 0) {
                buffer.append("&");
            }
            String name = enumeration.nextElement();
            buffer.append(String.valueOf(name) + "=" + NetworkHelper.encodeUrl(this.getRequest().getParameter(name)));
        }
        return buffer.toString();
    }

    public List<String> getAllSessionAttributesForDisplay() {
        ArrayList<String> attrStrings = new ArrayList<String>();
        Session currentSession = this.getSession(false);
        if (currentSession != null) {
            Enumeration<String> enumeration = currentSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String name = enumeration.nextElement();
                attrStrings.add(String.valueOf(name) + " = " + currentSession.getAttribute(name));
            }
        }
        return attrStrings;
    }

    public String getReferencedRender() {
        if (this.referencedRender != null) {
            return this.referencedRender;
        }
        return "none";
    }

    public String getRequestURI() {
        return this.getRequestUri();
    }

    @Deprecated
    public String getRequestValue(String name) {
        return this.query().get(name);
    }

    @Deprecated
    public void flush() {
        try {
            this.getRequest().getWriter().flush();
        }
        catch (IOException ioexc) {
            this.getLog().debug("IOException on flush().");
        }
    }

    @Deprecated
    public <O extends Enum<O>> O getEnumRequestValue(String name, Class<O> type, O defaultValue) {
        return this.query().getEnum(name, type, defaultValue);
    }

    public String getEscapedRequestValue(String name) {
        return NetworkHelper.escapeStringForHtml(this.query().get(name));
    }

    public String getEscapedRequestValue(String name, String defaultValue) {
        return NetworkHelper.escapeStringForHtml(this.query().get(name, defaultValue));
    }

    public String getEscapedCmdURL(String commandString) {
        return NetworkHelper.escapeStringForHtml(this.getCmdURL(commandString));
    }

    public String getEscapedCmdURL(String commandString, String paramKey, boolean paramValue) {
        return this.getEscapedCmdURL(commandString, paramKey, Boolean.toString(paramValue));
    }

    public String getEscapedCmdURL(String commandString, String paramKey, int paramValue) {
        return this.getEscapedCmdURL(commandString, paramKey, Integer.toString(paramValue));
    }

    public String getEscapedCmdURL(String commandString, String paramKey, String paramValue) {
        return this.getEscapedCmdURL(commandString, new String[]{paramKey}, new String[]{paramValue});
    }

    public String getEscapedCmdURL(String commandString, String[] paramKeys, String[] paramValues) {
        return NetworkHelper.escapeStringForHtml(this.getCmdURL(commandString, paramKeys, paramValues));
    }

    @Deprecated
    public void displayAllRequestHeaders() {
        List<String> headers = this.getAllRequestHeadersForDisplay();
        for (String header : headers) {
            this.getLog().debug("Request header: " + header);
        }
    }

    @Deprecated
    public void displayAllRequestParameters() {
        List<String> parameters = this.getAllRequestParametersForDisplay();
        for (String parameter : parameters) {
            this.getLog().debug("Request parameter: " + parameter);
        }
    }

    @Deprecated
    public void displayAllSessionAttributes() {
        List<String> attributes = this.getAllSessionAttributesForDisplay();
        for (String attribute : attributes) {
            this.getLog().debug("Session attribute: " + attribute);
        }
    }

    @Deprecated
    public void displaySessionInfo() {
        Session theSession = this.getSession(false);
        this.getLog().debug("Session: " + theSession);
        this.getLog().debug("Session.isNew: " + (theSession == null ? "no session" : "" + theSession.isNew()));
    }
}

