/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.LegacyContext;
import com.techempower.gemini.UrlRewriter;
import com.techempower.gemini.UrlRule;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PrettyUrlRewriter
extends UrlRewriter {
    private List<UrlRule> urlRules = new ArrayList<UrlRule>();

    public PrettyUrlRewriter(GeminiApplication application) {
        super(application);
        this.installRules();
    }

    protected abstract void installRules();

    @Override
    public void addRule(String rule, String command) {
        this.urlRules.add(new UrlRule(rule, command));
    }

    @Override
    public void parseRequest(LegacyContext context) {
        String[] split;
        String command = null;
        String uri = context.getRequestUri();
        uri = uri.replaceFirst(this.getApplication().getInfrastructure().getUrl(), "");
        for (UrlRule url : this.urlRules) {
            if (!url.matches(uri)) continue;
            if (uri.isEmpty() && context.query().get("cmd") != null) {
                command = context.query().get("cmd");
                Map<String, String> params = url.parseParams(uri);
                for (String key : params.keySet()) {
                    context.putRequestValue(key, params.get(key));
                }
            } else {
                command = url.getCommand();
                for (Map.Entry<String, String> entry : url.parseParams(uri).entrySet()) {
                    context.putRequestValue(entry.getKey(), entry.getValue());
                }
            }
            break;
        }
        if (command == null && (split = uri.split("\\/")).length != 0 && split.length <= 1 && !StringHelper.isEmptyTrimmed(split[0])) {
            command = split[0];
            for (UrlRule url : this.urlRules) {
                if (!url.getCommand().equalsIgnoreCase(command)) continue;
                command = null;
                break;
            }
        }
        context.setRewritten(true);
        context.putRequestValue("cmd", command);
    }

    @Override
    public String rewriteURL(String command, String[] paramKeys, String[] paramValues) {
        if (paramKeys != null && paramValues != null && paramKeys.length != paramValues.length) {
            return "/";
        }
        UrlRule match = null;
        HashMap<String, String> allParams = new HashMap<String, String>();
        if (paramKeys != null && paramValues != null) {
            int i = 0;
            while (i < paramKeys.length) {
                allParams.put(paramKeys[i], paramValues[i]);
                ++i;
            }
        }
        boolean commandFound = false;
        for (UrlRule rule : this.urlRules) {
            if (!rule.getCommand().equalsIgnoreCase(command) || !rule.matches(allParams)) continue;
            commandFound = true;
            match = rule;
            break;
        }
        if (match != null) {
            return match.toUrl(allParams);
        }
        if (!commandFound) {
            return this.rewriteURLDefault(command, paramKeys, paramValues);
        }
        return "/";
    }

    @Override
    public boolean accept(String command) {
        return true;
    }

    @Override
    public boolean accept(String command, String paramKey) {
        return true;
    }

    @Override
    public boolean accept(String command, String[] paramKeys) {
        return true;
    }

    @Override
    public List<String> getRule(String command) {
        ArrayList<String> rules = new ArrayList<String>();
        for (UrlRule rule : this.urlRules) {
            if (!rule.getCommand().equalsIgnoreCase(command)) continue;
            rules.add(rule.getRule());
        }
        return rules;
    }

    protected String rewriteURLDefault(String command, String[] paramKeys, String[] paramValues) {
        String toReturn = "/" + command;
        String queryString = NetworkHelper.getQueryString(paramKeys, paramValues);
        if (StringHelper.isNonEmpty(queryString)) {
            toReturn = String.valueOf(toReturn) + "?" + queryString;
        }
        return toReturn;
    }
}

