/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.gemini.HttpRequest;
import com.techempower.gemini.Request;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;

public final class RequestFile {
    private static final int BYTE_BUFFER_SIZE = 4096;
    private static final int CHAR_BUFFER_SIZE = 2048;
    private static final Pattern FILENAME_PATTERN = Pattern.compile("(.*)filename=\"(.*)\"");
    private final Part part;
    private final String filename;
    private final String contentType;

    private static <T> T checkNotNull(T object, String name) {
        if (object == null) {
            throw new IllegalArgumentException("Argument '" + name + "' must not be null.");
        }
        return object;
    }

    private static boolean isValidFilename(String filename) {
        Path normalized;
        Path path;
        if (filename == null) {
            return false;
        }
        try {
            path = Paths.get(filename, new String[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
        if (path.getNameCount() != 1 || path.isAbsolute()) {
            return false;
        }
        try {
            normalized = path.normalize();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        if (!path.equals(normalized)) {
            return false;
        }
        String pathname = normalized.toString();
        return !pathname.isEmpty() && !pathname.equals("..") && pathname.equals(filename);
    }

    private static boolean mightContainFiles(Request request) {
        return request instanceof HttpRequest && request.isPost() && ((HttpRequest)request).getRawRequest().getContentType().startsWith("multipart/form-data");
    }

    private static RequestFile fromPart(Part part) {
        if (part == null) {
            return null;
        }
        String contentDisposition = part.getHeader("content-disposition");
        if (contentDisposition == null) {
            return null;
        }
        Matcher matcher = FILENAME_PATTERN.matcher(contentDisposition);
        if (!matcher.matches()) {
            return null;
        }
        String filename = matcher.group(2);
        if (!RequestFile.isValidFilename(filename)) {
            return null;
        }
        String contentType = part.getContentType();
        if (contentType == null) {
            return null;
        }
        return new RequestFile(part, filename, contentType);
    }

    public static RequestFile get(Request request, String parameterName) {
        Part part;
        RequestFile.checkNotNull(request, "request");
        RequestFile.checkNotNull(parameterName, "parameterName");
        if (!RequestFile.mightContainFiles(request)) {
            return null;
        }
        HttpServletRequest servletRequest = ((HttpRequest)request).getRawRequest();
        try {
            part = servletRequest.getPart(parameterName);
        }
        catch (IOException | ServletException e) {
            return null;
        }
        return RequestFile.fromPart(part);
    }

    public static List<RequestFile> get(Request request) {
        Collection parts;
        RequestFile.checkNotNull(request, "request");
        if (!RequestFile.mightContainFiles(request)) {
            return Collections.emptyList();
        }
        HttpServletRequest servletRequest = ((HttpRequest)request).getRawRequest();
        try {
            parts = servletRequest.getParts();
        }
        catch (IOException | ServletException e) {
            return Collections.emptyList();
        }
        if (parts == null || parts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RequestFile> files = null;
        for (Part part : parts) {
            RequestFile file = RequestFile.fromPart(part);
            if (file == null) continue;
            if (files == null) {
                files = new ArrayList<RequestFile>();
            }
            files.add(file);
        }
        if (files == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(files);
    }

    private RequestFile(Part part, String filename, String contentType) {
        this.part = RequestFile.checkNotNull(part, "part");
        this.filename = RequestFile.checkNotNull(filename, "filename");
        this.contentType = RequestFile.checkNotNull(contentType, "contentType");
    }

    public String getParameterName() {
        return this.part.getName();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getSize() {
        return this.part.getSize();
    }

    public InputStream getContentAsStream() throws IOException {
        return this.part.getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getContentAsBytes() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            InputStream in = this.getContentAsStream();
            try {
                byte[] byArray;
                block16: {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try {
                        byte[] buffer = new byte[4096];
                        while (true) {
                            int bytesRead;
                            if ((bytesRead = in.read(buffer)) == -1) {
                                byArray = out.toByteArray();
                                return byArray;
                            }
                            out.write(buffer, 0, bytesRead);
                        }
                    }
                    finally {
                        if (out == null) break block16;
                        out.close();
                    }
                }
                if (in != null) {
                    in.close();
                }
                return byArray;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public String getContentAsString(Charset charset) throws IOException {
        RequestFile.checkNotNull(charset, "charset");
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStreamReader in = new InputStreamReader(this.getContentAsStream(), charset);){
            StringBuilder out = new StringBuilder();
            CharBuffer buffer = CharBuffer.allocate(2048);
            while (in.read(buffer) != -1) {
                buffer.flip();
                out.append(buffer);
                buffer.clear();
            }
            return out.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void writeTo(Path destination) throws IOException {
        RequestFile.checkNotNull(destination, "destination");
        Files.copy(this.getContentAsStream(), destination, StandardCopyOption.REPLACE_EXISTING);
    }

    public String toString() {
        return String.format("RequestFile{parameterName=%s, fileName=%s, type=%s, size=%s}", this.getParameterName(), this.getFilename(), this.getContentType(), this.getSize());
    }
}

