/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.notification;

import com.techempower.gemini.admin.notification.Notification;
import com.techempower.helper.DateHelper;
import java.util.Date;

public class BasicNotification
implements Notification {
    private final String source;
    private final String synopsis;
    private String details;
    private final Date time;
    private final Notification.Severity severity;
    private int sequenceNumber;

    public BasicNotification(String source, String synopsis, String details, Notification.Severity severity) {
        this.source = source;
        this.synopsis = synopsis;
        this.details = details;
        this.time = new Date();
        this.severity = severity;
    }

    public BasicNotification(String source, String synopsis, String details) {
        this(source, synopsis, details, Notification.Severity.MEDIUM);
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getSynopsis() {
        return this.synopsis;
    }

    @Override
    public String getDetails() {
        return this.details;
    }

    @Override
    public Notification.Severity getSeverity() {
        return this.severity;
    }

    @Override
    public Date getTime() {
        return DateHelper.copy(this.time);
    }

    @Override
    public void purgeDetails() {
        this.details = null;
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String toString() {
        return "Notification [" + this.getSequenceNumber() + "; " + this.getTime() + "; from " + this.getSource() + "]";
    }
}

