/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.cache;

import com.techempower.data.EntityGroup;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.cache.CacheCategory;
import com.techempower.log.ComponentLog;
import com.techempower.util.Identifiable;

public class CacheReset
extends BasicAdminFunction {
    public CacheReset() {
        super("reset", "Cache Reset", "Reset object caches", "cache", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Class<? extends Identifiable> clazz = CacheCategory.getCacheClass(context.query().get("cid"));
        if (clazz == null) {
            if (BasicAdminHandler.isNonceCorrect(context)) {
                app.getStore().reset(true);
                context.messages().success("Full cache reset.");
                return bah.redirectRelative(String.valueOf(this.getFunctionCategory()) + "/list");
            }
            return bah.handleConfirmation(context, 10, "Full cache reset", String.valueOf(this.getPathSegment()) + "?cid=0");
        }
        EntityGroup<? extends Identifiable> group = app.getStore().getGroup(clazz);
        if (group != null) {
            if (BasicAdminHandler.isNonceCorrect(context)) {
                app.getStore().reset(clazz, true);
                context.messages().success("Class " + clazz.getName() + " reset.");
                return bah.redirectRelative(String.valueOf(this.getFunctionCategory()) + "/list");
            }
            return bah.handleConfirmation(context, 5, "Reset cache for " + clazz.getName(), String.valueOf(this.getPathSegment()) + "?cid=" + clazz.getName());
        }
        return false;
    }
}

