/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.cache;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.cache.CacheCategory;
import com.techempower.log.ComponentLog;
import com.techempower.util.Identifiable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class ObjectCall
extends BasicAdminFunction {
    public ObjectCall() {
        super("object-call", "View Object", "View a cached object", "cache", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        return this.go(context, bah, app, log);
    }

    protected <T extends Identifiable> boolean go(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Class<? extends Identifiable> clazz = CacheCategory.getCacheClass(context.query().get("cid"));
        if (clazz != null) {
            Identifiable obj = null;
            int id = context.query().getInt("id");
            if (id > 0 && (obj = app.getStore().get(clazz, id)) != null) {
                String getMethodName = context.query().get("m", "");
                if (getMethodName.startsWith("get") || getMethodName.matches("^[i][s][A-Z].*")) {
                    String value = "[Unable to invoke " + getMethodName + "]";
                    try {
                        Method method = obj.getClass().getMethod(getMethodName, CacheCategory.NO_PARAMS);
                        if (method.getName().startsWith("is") && method.getReturnType() != Boolean.TYPE && method.getReturnType() != Boolean.class) {
                            return GeminiHelper.sendJson(context, "r", "--");
                        }
                        value = "" + method.invoke((Object)obj, CacheCategory.NO_VALUES);
                    }
                    catch (Exception exc) {
                        value = "Exception: " + exc.getClass().getName();
                    }
                    return GeminiHelper.sendJson(context, "r", value);
                }
                if (getMethodName.equals("all")) {
                    log.log("Calling all methods in " + obj);
                    List<String> getMethods = CacheCategory.decomposeObjectGetMethods(obj.getClass());
                    Map<String, String> map = CacheCategory.decomposeObjectMethodValues(obj, getMethods);
                    return GeminiHelper.sendJson(context, "r", map);
                }
            }
        }
        return GeminiHelper.sendJson(context, "r", "--");
    }
}

