/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.cache;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.BasicAdminPaging;
import com.techempower.gemini.admin.standard.cache.CacheCategory;
import com.techempower.gemini.form.BasicForm;
import com.techempower.gemini.form.FormHidden;
import com.techempower.gemini.form.FormSelect;
import com.techempower.gemini.form.FormSubmitButton;
import com.techempower.gemini.form.FormTextField;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Identifiable;
import java.util.ArrayList;
import java.util.List;

public class ObjectList
extends BasicAdminFunction {
    public ObjectList() {
        super("object-list", "List Objects", "List of cached objects", "cache", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Class<? extends Identifiable> clazz = CacheCategory.getCacheClass(context.query().get("cid"));
        if (clazz != null) {
            String methodName = context.query().get("m");
            String value = context.query().get("v");
            List<? extends Identifiable> objects = StringHelper.isEmpty(methodName) || !methodName.startsWith("get") || StringHelper.isEmpty(value) ? app.getStore().list(clazz) : app.getStore().list(clazz, methodName, value, true);
            if (objects != null) {
                BasicForm form = new BasicForm(app, "objectlist", context.getRequestUri(), "get");
                List<String> methodNames = CacheCategory.decomposeObjectGetMethods(clazz);
                methodNames.add(0, "");
                FormSelect methodField = new FormSelect("m", form);
                methodField.addOptionsFromCollection(methodNames);
                FormTextField valueField = new FormTextField("v");
                form.add(valueField);
                form.add(new FormHidden("cid", clazz.getName()));
                form.add(new FormSubmitButton("filter", "Filter", true));
                form.setValues(context);
                int currentPage = context.query().getInt("p", 1);
                String baseURL = String.valueOf(this.getPathSegment()) + "?cid=" + clazz.getName();
                BasicAdminPaging paging = new BasicAdminPaging(context, baseURL, objects.size(), currentPage, 50);
                context.delivery().putObject("form", form).putObject("paging", paging).putObject("objects", paging.extractCurrentPage((ArrayList)objects)).put("className", clazz.getName());
                return bah.mustache(this.getTemplateName());
            }
        }
        return false;
    }
}

