/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.cache;

import com.techempower.data.EntityRelation;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.log.ComponentLog;

public class RelationRemove
extends BasicAdminFunction {
    public RelationRemove() {
        super("relation-remove", "Remove Relation", "Remove a cached relation", "cache", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        EntityRelation<?, ?> relation = app.getStore().getRelation(context.query().get("relation"));
        int leftID = context.query().getInt("left");
        int rightID = context.query().getInt("right");
        if (BasicAdminHandler.isNonceCorrect(context)) {
            relation.remove(leftID, rightID);
            context.messages().success("Relation pair removed");
            return bah.redirectRelative(this.getRelativeUri());
        }
        return bah.handleConfirmation(context, 10, "Relation pair remove", String.valueOf(this.getPathSegment()) + "?relation=" + relation.tableName() + "&left=" + leftID + "&right=" + rightID);
    }
}

