/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.cluster;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.cluster.ClusterCategory;
import com.techempower.gemini.cluster.client.ClusterClient;
import com.techempower.gemini.cluster.message.ClusterStatusRequest;
import com.techempower.gemini.cluster.message.ClusterStatusResponse;
import com.techempower.js.JavaScriptWriter;
import com.techempower.js.Visitors;
import com.techempower.log.ComponentLog;
import java.util.HashMap;

public class ClusterStatus
extends BasicAdminFunction {
    public static final JavaScriptWriter JSW = JavaScriptWriter.custom().addVisitorFactory(ClusterStatusResponse.NodeStatus.class, Visitors.forClass(ClusterStatusResponse.NodeStatus.class, "id", "getNodeId", "ch", "getChannelName", "ct", "getConnectionTime", "et", "getElapsedTime", "het", "getHumanElapsedTime", "mc", "getMessageCount", "name", "getName", "desc", "getDescription")).build();

    public ClusterStatus() {
        super("status", "Cluster Status", "Fetches status from the Cluster Master", "cluster");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        ClusterClient cc = app.getClusterClient();
        if (!cc.isEnabled()) {
            return ClusterCategory.handleNoCluster(context, bah);
        }
        if (context.query().getInt("mode") == 1) {
            ClusterStatusRequest request = new ClusterStatusRequest();
            ClusterStatusResponse response = (ClusterStatusResponse)cc.sendRequest(request);
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("nodes", response != null ? response.nodes : "");
            map.put("thisnode", cc.getNodeId());
            return GeminiHelper.sendJson(context, map, JSW);
        }
        return bah.mustache(this.getTemplateName());
    }
}

