/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.config;

import com.google.common.collect.Ordering;
import com.techempower.gemini.Configurator;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;

public class ConfigurationView
extends BasicAdminFunction {
    public ConfigurationView() {
        super("config-view", "View Configuration", "View the application's configuration", "config");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Configurator config = app.getConfigurator();
        EnhancedProperties running = config.getLastProperties();
        ArrayList<String> keys = new ArrayList<String>(running.size());
        Enumeration<Object> elements = running.keys();
        while (elements.hasMoreElements()) {
            keys.add(elements.nextElement().toString());
        }
        Collections.sort(keys, Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).nullsFirst());
        ArrayList<String> values = new ArrayList<String>(keys.size());
        for (String key : keys) {
            values.add(running.getProperty(key));
        }
        ArrayList configuration = new ArrayList();
        int i = 0;
        while (i < keys.size()) {
            HashMap row = new HashMap();
            row.put("key", keys.get(i));
            row.put("value", values.get(i));
            configuration.add(row);
            ++i;
        }
        context.delivery().putObject("rows", configuration);
        return bah.mustache(this.getTemplateName());
    }
}

