/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.config;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.feature.FeatureNode;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;

public class FeatureState
extends BasicAdminFunction {
    public FeatureState() {
        super("feature-state", "Toggle Feature", "Toggle a feature's state", "config", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        boolean state = true;
        String feature = context.query().get("enable", "");
        if (StringHelper.isEmpty(feature)) {
            state = false;
            feature = context.query().get("disable", "");
        }
        if (StringHelper.isNonEmpty(feature)) {
            FeatureNode node = app.getFeatureManager().get(feature);
            if (node == null) {
                return bah.handleInformation(context, 0, "Feature \"" + feature + "\" is unknown.");
            }
            if (BasicAdminHandler.isNonceCorrect(context)) {
                app.getFeatureManager().set(feature, state);
                context.messages().success("Feature \"" + feature + "\" " + (state ? "enabled" : "disabled") + ".");
                return bah.redirectRelative(bah.getFunction("config-features").getRelativeUri());
            }
            return bah.handleConfirmation(context, 10, String.valueOf(state ? "Enable" : "Disable") + " feature \"" + feature + "\" (" + node.getDescription() + ")", String.valueOf(this.getPathSegment()) + "?" + (state ? "enable" : "disable") + "=" + feature);
        }
        return bah.handleInformation(context, 0, "Unknown feature.");
    }
}

