/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.email;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.email.inbound.EmailDispatcher;
import com.techempower.log.ComponentLog;

public class InboundEmailImmediate
extends BasicAdminFunction {
    public InboundEmailImmediate() {
        super("inbound-email-immediate", "Process Inbound", "Process inbound e-mail immediately", "email");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        EmailDispatcher disp = app.getEmailDispatcher();
        if (disp != null) {
            if (disp.isPaused()) {
                return bah.handleInformation(context, 5, "Inbound email is paused.  Unpause inbound email processing and then try again.");
            }
            disp.requestImmediateCheck();
            context.messages().success("Immediate inound email check requested.");
            return bah.redirectRelative(String.valueOf(this.getFunctionCategory()) + "/queues");
        }
        return bah.handleInformation(context, 0, "This application does not process inbound email.");
    }
}

