/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.monitor;

import com.techempower.data.ConnectorFactory;
import com.techempower.data.jdbc.BasicConnectorFactory;
import com.techempower.data.jdbc.JdbcConnectionManager;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.log.ComponentLog;

public class JdbcConnections
extends BasicAdminFunction {
    public JdbcConnections() {
        super("jdbc-connections", "JDBC", "List JDBC connections", "monitor");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        ConnectorFactory connfactory = app.getConnectorFactory();
        if (connfactory != null && connfactory instanceof BasicConnectorFactory) {
            BasicConnectorFactory bcf = (BasicConnectorFactory)connfactory;
            JdbcConnectionManager manager = bcf.getConnectionManager();
            if (manager != null) {
                context.delivery().putObject("profiles", manager.getProfiles());
            }
            return bah.mustache(this.getTemplateName());
        }
        return bah.handleInformation(context, 5, "This application does not use a BasicConnectorFactory and therefore JDBC Profiles cannot be retrieved.");
    }
}

