/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.monitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.monitor.MonitorCategory;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.cpupercentage.PercentageSample;
import com.techempower.log.ComponentLog;
import java.util.List;

public class MonitorCpu
extends BasicAdminFunction {
    public MonitorCpu() {
        super("monitor-cpu", "CPU", "Monitor CPU utilization per thread", "monitor");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        GeminiMonitor monitor = app.getMonitor();
        if (monitor == null) {
            return bah.handleInformation(context, 0, "This application does not use a Monitor, so this functionality is not available.");
        }
        if (!monitor.isEnabled()) {
            return bah.handleInformation(context, 0, "The Gemini Monitor is disabled.  Check application configuration files if this is unexpected.");
        }
        List<PercentageSample> samples = monitor.getCpuUsagePercentages();
        if (context.query().getInt("mode") == 1) {
            return GeminiHelper.sendJson(context, "samples", samples, MonitorCategory.JSW);
        }
        context.delivery().put("samples", MonitorCategory.JSW.write(samples));
        return bah.mustache(this.getTemplateName());
    }
}

