/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.monitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.monitor.MonitorCategory;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.MonitorSample;
import com.techempower.helper.DateHelper;
import com.techempower.log.ComponentLog;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class MonitorCurrent
extends BasicAdminFunction {
    public static final int DEFAULT_MAP_SIZE = 5;

    public MonitorCurrent() {
        super("monitor-current", "Requests", "Monitor current requests", "monitor");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        GeminiMonitor monitor = app.getMonitor();
        if (monitor == null) {
            return bah.handleInformation(context, 0, "This application does not use a Monitor, so this functionality is not available.");
        }
        if (!monitor.isEnabled()) {
            return bah.handleInformation(context, 0, "The Gemini Monitor is disabled.  Check application configuration files if this is unexpected.");
        }
        List<MonitorSample> requests = monitor.getCurrentRequests();
        Collections.sort(requests);
        long uptime = app.getUptime();
        String uptimeRendering = String.valueOf(DateHelper.getHumanDuration(uptime, 2)) + " of uptime (" + uptime + " millis)";
        if (context.query().getInt("mode") == 1) {
            HashMap<String, Object> toReturn = new HashMap<String, Object>(5);
            toReturn.put("requests", MonitorCategory.CURRENT_REQS_JSW.write(requests));
            toReturn.put("interval", monitor.getHealthIntervalLength());
            toReturn.put("tzshift", DateHelper.getCurrentTimeZoneOFfset());
            toReturn.put("uptime", uptimeRendering);
            toReturn.put("health", monitor.getHealthSnapshots());
            return GeminiHelper.sendJson(context, toReturn, MonitorCategory.CURRENT_REQS_JSW);
        }
        context.delivery().put("requests", MonitorCategory.CURRENT_REQS_JSW.write(requests)).put("intervalLength", monitor.getHealthIntervalLength()).put("timezoneShift", DateHelper.getCurrentTimeZoneOFfset()).put("uptime", uptimeRendering);
        return bah.mustache(this.getTemplateName());
    }
}

