/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.monitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.monitor.MonitorCategory;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.MonitoredCommand;
import com.techempower.helper.DateHelper;
import com.techempower.log.ComponentLog;

public class MonitorDetail
extends BasicAdminFunction {
    public MonitorDetail() {
        super("monitor-detail", "Request Details", "View request details", "monitor", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        GeminiMonitor monitor = app.getMonitor();
        if (monitor == null) {
            return bah.handleInformation(context, 0, "This application does not use a Monitor, so this functionality is not available.");
        }
        if (!monitor.isEnabled()) {
            return bah.handleInformation(context, 0, "The Gemini Monitor is disabled.  Check application configuration files if this is unexpected.");
        }
        String command = context.query().get("command");
        MonitoredCommand mc = monitor.getMonitoredCommand(context.query().get("command"));
        if (mc != null) {
            context.delivery().put("command", command).put("MC", MonitorCategory.JSW.write(mc)).put("history", MonitorCategory.JSW.write(mc.getHistory())).put("intervalLength", monitor.getPerfIntervalLength()).put("timezoneShift", DateHelper.getCurrentTimeZoneOFfset());
            return bah.mustache(this.getTemplateName());
        }
        return bah.handleInformation(context, 0, "No detail is available for the requested monitored command.");
    }
}

