/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.monitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.monitor.MonitorCategory;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.MonitoredCommand;
import com.techempower.helper.DateHelper;
import com.techempower.log.ComponentLog;
import java.util.HashMap;
import java.util.List;

public class MonitorList
extends BasicAdminFunction {
    public static final int DEFAULT_MAP_SIZE = 5;

    public MonitorList() {
        super("monitor-list", "Performance", "List performance for observed commands", "monitor");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        GeminiMonitor monitor = app.getMonitor();
        if (monitor == null) {
            return bah.handleInformation(context, 0, "This application does not use a Monitor, so this functionality is not available.");
        }
        if (!monitor.isEnabled()) {
            return bah.handleInformation(context, 0, "The Gemini Monitor is disabled.  Check application configuration files if this is unexpected.");
        }
        List<MonitoredCommand> commands = monitor.getMonitoredCommands();
        long uptime = app.getUptime();
        String uptimeRendering = String.valueOf(DateHelper.getHumanDuration(uptime, 2)) + " of uptime (" + uptime + " millis)";
        if (context.query().getInt("mode") == 1) {
            HashMap<String, Object> toReturn = new HashMap<String, Object>(5);
            toReturn.put("commands", commands);
            toReturn.put("interval", monitor.getHealthIntervalLength());
            toReturn.put("tzshift", DateHelper.getCurrentTimeZoneOFfset());
            toReturn.put("uptime", uptimeRendering);
            toReturn.put("health", monitor.getHealthSnapshots());
            return GeminiHelper.sendJson(context, toReturn, MonitorCategory.JSW);
        }
        context.delivery().put("commands", MonitorCategory.JSW.write(commands)).put("intervalLength", monitor.getHealthIntervalLength()).put("timezoneShift", DateHelper.getCurrentTimeZoneOFfset()).put("uptime", uptimeRendering);
        return bah.mustache(this.getTemplateName());
    }
}

