/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.monitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.users.UserList;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.pyxis.BasicWebUser;
import com.techempower.log.ComponentLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class SessionList
extends BasicAdminFunction {
    public SessionList() {
        super("session-list", "Session List", "List active user sessions", "monitor");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        UserList userList = (UserList)bah.getFunction("users-user-list");
        if (userList != null) {
            GeminiMonitor monitor = app.getMonitor();
            if (monitor == null) {
                return bah.handleInformation(context, 0, "This application does not use a Monitor, so this functionality is not available.");
            }
            if (!monitor.isSessionEnabled()) {
                return bah.handleInformation(context, 0, "The Gemini Monitor's session monitoring function is disabled.  Check application configuration files if this is unexpected.");
            }
            Set<HttpSession> set = monitor.getSessions();
            ArrayList<BasicWebUser> users = new ArrayList<BasicWebUser>(set.size());
            Iterator<HttpSession> iter = set.iterator();
            while (iter.hasNext()) {
                com.techempower.gemini.session.HttpSession refSes = com.techempower.gemini.session.HttpSession.createSession(iter.next());
                BasicWebUser user = (BasicWebUser)app.getSecurity().getUser(refSes);
                if (user == null) {
                    user = (BasicWebUser)app.getSecurity().constructUser();
                    user.setUserUsername("( Visitor )");
                    user.setUserFirstname("Session ID #");
                    user.setUserLastname("" + refSes.getAttribute("Gemini-Session-ID"));
                }
                users.add(user);
            }
            return userList.handleUserList(bah, app, log, context, users);
        }
        return bah.handleInformation(context, 5, "No user-list function available for rendering session list.");
    }
}

