/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.monitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.session.SessionSnapshot;
import com.techempower.log.ComponentLog;

public class SessionView
extends BasicAdminFunction {
    public SessionView() {
        super("session-view", "Session Trend", "View session trend over time", "monitor");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        GeminiMonitor monitor = app.getMonitor();
        if (monitor == null) {
            return bah.handleInformation(context, 0, "This application does not use a Monitor, so this functionality is not available.");
        }
        if (!monitor.isSessionEnabled()) {
            return bah.handleInformation(context, 0, "The Gemini Monitor's session monitoring function is disabled.  Check application configuration files if this is unexpected.");
        }
        SessionSnapshot[] snapshots = monitor.getSessionSnapshots();
        context.delivery().putObject("sessionSnapshots", snapshots).putObject("sessionManager", app.getSessionManager());
        return bah.mustache(this.getTemplateName());
    }
}

