/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.system;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.system.SystemCategory;
import com.techempower.helper.DateHelper;
import com.techempower.log.ComponentLog;
import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.Scheduler;
import com.techempower.scheduler.SchedulerThread;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EventList
extends BasicAdminFunction {
    public EventList() {
        super("event-list", "Events", "List and manage application events", "system");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Scheduler scheduler = SystemCategory.getSchedulerReference(bah, app, context);
        if (scheduler == null) {
            return true;
        }
        List<ScheduledEvent> events = scheduler.getEvents();
        ArrayList<EventView> rendered = new ArrayList<EventView>(events.size());
        int id = 0;
        for (ScheduledEvent event : events) {
            rendered.add(new EventView(event, id));
            ++id;
        }
        context.delivery().putObject("events", rendered);
        context.delivery().put("sleepTime", scheduler.getSleepTime());
        SchedulerThread thread = scheduler.getSchedulerThread();
        if (thread == null) {
            context.messages().warning("Scheduler thread is not running.  Scheduled events will not be run.");
        } else {
            context.delivery().put("nextCheck", DateHelper.STANDARD_TECH_FORMAT.format(new Date(thread.getNextCheckTime())));
        }
        long uptime = app.getUptime();
        context.delivery().put("uptime", String.valueOf(DateHelper.getHumanDuration(uptime, 2)) + " (" + uptime + " milliseconds)");
        return bah.mustache(this.getTemplateName());
    }

    public static class EventView {
        public final int id;
        public final boolean enabled;
        public final String name;
        public final String executing;
        public final String lastRun;
        public final String lastDuration;
        public final String lastCompletion;
        public final String nextRun;

        public EventView(ScheduledEvent event, int id) {
            this.id = id;
            this.enabled = event.isEnabled();
            Date eventDate = event.getScheduledTimeAsDate();
            Date now = new Date();
            long lastRunTimeLong = event.getLastRunTime();
            long lastCompletionLong = event.getLastCompleteTime();
            long lastDurationLong = event.getLastRunDuration();
            this.name = event.getName().equals(event.getDescription()) ? event.getName() : "<abbr title='" + event.getDescription() + "'>" + event.getName() + "</abbr>";
            if (event.isExecuting()) {
                long sinceStart = System.currentTimeMillis() - lastRunTimeLong;
                this.executing = DateHelper.getHumanDuration(sinceStart, 1);
            } else {
                this.executing = null;
            }
            this.lastRun = lastRunTimeLong > 0L ? DateHelper.STANDARD_TECH_FORMAT.format(new Date(lastRunTimeLong)) : "--";
            this.lastDuration = lastDurationLong > 0L ? DateHelper.getHumanDuration(lastDurationLong, 1) : "--";
            this.lastCompletion = lastRunTimeLong > 0L ? DateHelper.STANDARD_TECH_FORMAT.format(new Date(lastCompletionLong)) : "--";
            this.nextRun = String.valueOf(DateHelper.STANDARD_TECH_FORMAT.format(eventDate)) + " (" + DateHelper.getHumanDifference(now, eventDate, 2) + ")";
        }
    }
}

