/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.system;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.system.SystemCategory;
import com.techempower.log.ComponentLog;
import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.Scheduler;

public class EventPauseResume
extends BasicAdminFunction {
    public EventPauseResume() {
        super("event-pause-resume", "Event Pause", "Pause a system event", "system", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Scheduler scheduler = SystemCategory.getSchedulerReference(bah, app, context);
        if (scheduler == null) {
            return true;
        }
        int id = context.query().getInt("id");
        ScheduledEvent event = scheduler.getEvent(id);
        if (event != null) {
            boolean enabled = !event.isEnabled();
            event.setEnabled(enabled);
            if (enabled) {
                context.messages().normal(String.valueOf(event.getName()) + " enabled.");
                log.log(String.valueOf(event.getName()) + " enabled.");
            } else if (event.isExecuting()) {
                context.messages().warning(String.valueOf(event.getName()) + " disabled." + "  Note that the event is currently executing and disabling an event does not interrupt execution.");
                log.log(String.valueOf(event.getName()) + " disabled, but currently executing.");
            } else {
                context.messages().normal(String.valueOf(event.getName()) + " disabled.");
                log.log(String.valueOf(event.getName()) + " disabled.");
            }
            return bah.redirectRelative(bah.getFunction("system-event-list").getRelativeUri());
        }
        return false;
    }
}

