/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.system;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.system.SystemCategory;
import com.techempower.log.ComponentLog;
import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.Scheduler;

public class EventRun
extends BasicAdminFunction {
    public EventRun() {
        super("event-run", "Event Run", "Run a system event", "system", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Scheduler scheduler = SystemCategory.getSchedulerReference(bah, app, context);
        if (scheduler == null) {
            return true;
        }
        int id = context.query().getInt("id");
        ScheduledEvent event = scheduler.getEvent(id);
        if (event != null) {
            if (BasicAdminHandler.isNonceCorrect(context)) {
                boolean success = scheduler.executeEventNewThread(event, true);
                if (success) {
                    context.messages().success(String.valueOf(event.getName()) + " executing.");
                } else {
                    context.messages().normal(String.valueOf(event.getName()) + " could not be executed (may already be running).");
                }
                return bah.redirectRelative(bah.getFunction("system-event-list").getRelativeUri());
            }
            if (!event.isEnabled()) {
                context.delivery().put("AuxMessage", "Although this event is currently disabled, it may be executed on demand.");
            }
            return bah.handleConfirmation(context, 5, "Run " + event.getName() + " immediately", String.valueOf(this.getPathSegment()) + "?id=" + id);
        }
        return false;
    }
}

