/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.system;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.helper.ThreadHelper;
import com.techempower.log.ComponentLog;
import com.techempower.thread.EndableThread;

public class ThreadEnd
extends BasicAdminFunction {
    public ThreadEnd() {
        super("thread-end", "End Thread", "End a running thread", "system", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Thread thread;
        long id = context.query().getInt("id", -1);
        if (id >= 0L && (thread = ThreadHelper.getThread(id)) != null && thread instanceof EndableThread) {
            EndableThread et = (EndableThread)thread;
            if (BasicAdminHandler.isNonceCorrect(context)) {
                et.setKeepRunning(false);
                log.log(String.valueOf(et.getName()) + " set to stop running.");
                context.messages().success(String.valueOf(et.getName()) + " has been signalled to stop executing.");
                return bah.redirectRelative(bah.getFunction("system-thread-list").getRelativeUri());
            }
            return bah.handleConfirmation(context, 10, "Stop executing " + et.getName() + "?  Note that the application may need to be restarted in order to re-execute this thread.", String.valueOf(this.getPathSegment()) + "?id=" + id);
        }
        context.messages().warning("Threads that are not EndableThread subclasses cannot be ended.");
        return bah.redirectRelative(this.getFunctionCategory());
    }
}

