/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.system;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.helper.ThreadHelper;
import com.techempower.log.ComponentLog;

public class ThreadInterrupt
extends BasicAdminFunction {
    public ThreadInterrupt() {
        super("thread-interrupt", "Interrupt Thread", "Interrupt a running thread", "system", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Thread thread;
        long id = context.query().getInt("id", -1);
        if (id >= 0L && (thread = ThreadHelper.getThread(id)) != null) {
            if (BasicAdminHandler.isNonceCorrect(context)) {
                thread.interrupt();
                context.messages().success(String.valueOf(thread.getName()) + " has been interrupted.");
                return bah.redirectRelative(bah.getFunction("system-thread-list").getRelativeUri());
            }
            return bah.handleConfirmation(context, 5, "Interrupt " + thread.getName() + "?  Doing so may have cause unpredictable results.", String.valueOf(this.getPathSegment()) + "?id=" + id);
        }
        context.messages().warning("The requested thread is not available.");
        return bah.redirectRelative(this.getFunctionCategory());
    }
}

