/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.system;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.MonitorSample;
import com.techempower.helper.DateHelper;
import com.techempower.helper.ThreadHelper;
import com.techempower.log.ComponentLog;
import com.techempower.thread.EndableThread;
import com.techempower.util.StringList;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;

public class ThreadList
extends BasicAdminFunction {
    public ThreadList() {
        super("thread-list", "Thread List", "List and manage active threads", "system");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        GeminiMonitor monitor;
        Thread[] activeThreads = ThreadHelper.getActiveThreads(true);
        ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();
        if (tmxb.isThreadCpuTimeEnabled()) {
            context.delivery().putObject("tmxb", tmxb);
        }
        if ((monitor = app.getMonitor()) != null && monitor.isEnabled()) {
            context.delivery().putObject("monitor", monitor);
        }
        ArrayList threads = new ArrayList();
        Thread[] threadArray = activeThreads;
        int n = activeThreads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread aThread = threadArray[n2];
            HashMap<String, Object> thread = new HashMap<String, Object>();
            String classnameShort = aThread.getClass().getName().substring(aThread.getClass().getName().lastIndexOf(46) + 1);
            if (classnameShort.contains("$")) {
                classnameShort = classnameShort.substring(classnameShort.lastIndexOf("$") + 1);
            }
            thread.put("classnameShort", classnameShort);
            thread.put("classname", aThread.getClass().getName());
            thread.put("name", aThread.getName());
            thread.put("id", aThread.getId());
            String priorityName = "medpri";
            if (aThread.getPriority() < 5) {
                priorityName = "lowpri";
            } else if (aThread.getPriority() > 5) {
                priorityName = "highpri";
            }
            thread.put("priority", aThread.getPriority());
            thread.put("priorityName", priorityName);
            String stateStyle = "";
            String runTime = "--";
            String cpu = "--";
            String requestCpu = "--";
            Thread.State state = aThread.getState();
            boolean endable = false;
            boolean paused = false;
            StringList flags = new StringList(", ");
            if (aThread.isDaemon()) {
                flags.add("Daemon");
            }
            if (aThread instanceof EndableThread) {
                runTime = DateHelper.getHumanDuration(((EndableThread)aThread).getThreadLifetime(), 1);
                EndableThread et = (EndableThread)aThread;
                endable = true;
                if (et.isPaused()) {
                    if (et.isPauseChecked()) {
                        flags.add("Paused");
                        stateStyle = "paused";
                    } else {
                        flags.add("Pause pending");
                        stateStyle = "pausepending";
                    }
                    paused = true;
                } else {
                    flags.add("Running");
                }
                if (tmxb.isThreadCpuTimeEnabled()) {
                    MonitorSample sample;
                    long cputime = tmxb.getThreadCpuTime(aThread.getId());
                    long cpums = cputime / 1000000L;
                    if (cpums > 1000L) {
                        cpu = DateHelper.getHumanDuration(cpums, 1);
                    }
                    if (monitor != null && (sample = monitor.getRequest(aThread.getId())) != null) {
                        requestCpu = DateHelper.getHumanDuration(sample.getTotalCpuTimeInProgress(), 1);
                    }
                }
            }
            if (!endable) {
                if (state == Thread.State.NEW) {
                    flags.add("New");
                } else if (state == Thread.State.RUNNABLE) {
                    flags.add("Running");
                } else if (state == Thread.State.BLOCKED) {
                    flags.add("Blocked");
                } else if (state == Thread.State.WAITING) {
                    flags.add("Waiting");
                } else if (state == Thread.State.TIMED_WAITING) {
                    flags.add("Timed-Waiting");
                } else if (state == Thread.State.TERMINATED) {
                    flags.add("Terminated");
                }
            }
            thread.put("endable", endable);
            thread.put("paused", paused);
            thread.put("runtime", runTime);
            thread.put("cpu", cpu);
            thread.put("requestCpu", requestCpu);
            thread.put("stateStyle", stateStyle);
            thread.put("flags", flags);
            threads.add(thread);
            ++n2;
        }
        context.delivery().putObject("threads", threads);
        return bah.mustache(this.getTemplateName());
    }
}

