/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.system;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.helper.ThreadHelper;
import com.techempower.log.ComponentLog;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;

public class ThreadView
extends BasicAdminFunction {
    public ThreadView() {
        super("thread-view", "Thread View", "View a thread's trace", "system", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Thread thread;
        long id = context.query().getInt("id", -1);
        if (id >= 0L && (thread = ThreadHelper.getThread(id)) != null) {
            StackTraceElement[] stackTrace = thread.getStackTrace();
            ArrayList trace = new ArrayList();
            int index = 0;
            StackTraceElement[] stackTraceElementArray = stackTrace;
            int n = stackTrace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement aTrace = stackTraceElementArray[n2];
                HashMap<String, Serializable> t = new HashMap<String, Serializable>();
                t.put("index", Integer.valueOf(index));
                t.put("trace", aTrace);
                trace.add(t);
                ++index;
                ++n2;
            }
            context.delivery().putObject("thread", thread).putObject("trace", trace);
            ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();
            if (tmxb.isThreadCpuTimeEnabled()) {
                long cpuTime = tmxb.getThreadCpuTime(thread.getId());
                context.delivery().put("ns", cpuTime);
                context.delivery().put("cpuTime", cpuTime / 1000000L);
            }
            context.delivery().put("priority", thread.getPriority());
            if (thread.getPriority() < 5) {
                context.delivery().put("priorityName", "Low");
            } else if (thread.getPriority() == 5) {
                context.delivery().put("priorityName", "Normal");
            } else {
                context.delivery().put("priorityName", "High");
            }
            return bah.mustache(this.getTemplateName());
        }
        return bah.handleInformation(context, 0, "That thread is no longer running or is otherwise unavailable for viewing.");
    }
}

