/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.users;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.form.FormHidden;
import com.techempower.gemini.form.FormSubmitButton;
import com.techempower.gemini.form.FormTextArea;
import com.techempower.gemini.form.FormTextField;
import com.techempower.gemini.form.FormValidation;
import com.techempower.gemini.form.PostOnlyForm;
import com.techempower.gemini.pyxis.BasicUserGroup;
import com.techempower.log.ComponentLog;
import com.techempower.util.Identifiable;

public class GroupEdit
extends BasicAdminFunction {
    public GroupEdit() {
        super("group-edit", "Group Edit", "Edit a user group", "users", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        int id = context.query().getInt("id", -1);
        BasicUserGroup group = bah.getUserGroup(id);
        if (group.getType() == 2) {
            PostOnlyForm form = new PostOnlyForm(app, "groupedit", context.getUrl(), "post");
            form.add(new FormHidden("cmd", this.getPathSegment()));
            if (group.getId() > 0) {
                context.delivery().putObject("groupId", group.getId());
                form.add(new FormHidden("id", "" + id));
            }
            form.add(new FormTextField("Group Name", "name", group.getName(), true, 50, 50).setMinLength(1));
            form.add(new FormTextArea("description", group.getDescription(), false, "auto").setMaxLength(500).setDisplayName("Group description"));
            form.add(new FormSubmitButton("save", "Save", true));
            context.delivery().putObject("form", form);
            if (form.hasBeenSubmitted(context)) {
                FormValidation validation = form.validate(context);
                if (validation.isGood()) {
                    group.setName(form.values().get("name"));
                    group.setDescription(form.values().get("description"));
                    if (group.getId() == 0) {
                        Identifiable highest = app.getStore().getHighestIdentity(bah.getUserGroupClass());
                        group.setGroupID(highest.getId() + 1);
                    }
                    app.getStore().put(group);
                    context.messages().success("Changes saved.");
                    return bah.redirectRelative(String.valueOf(this.getRelativeUri()) + "?id=" + group.getId());
                }
                context.delivery().putObject("validation", validation);
            }
            return bah.mustache(this.getTemplateName());
        }
        return bah.handleInformation(context, 0, "The selected user group is not an administrator-defined group and therefore cannot be edited.");
    }
}

