/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.users;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.pyxis.BasicUserGroup;
import com.techempower.gemini.pyxis.BasicWebUser;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.PyxisUserGroup;
import com.techempower.log.ComponentLog;
import java.util.ArrayList;
import java.util.Collection;

public class GroupMembership
extends BasicAdminFunction {
    public GroupMembership() {
        super("group-membership-edit", "Group Membership", "User group membership", "users", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        int id = context.query().getInt("id");
        BasicWebUser user = bah.getUser(id);
        if (user != null) {
            int add = context.query().getInt("add", -1);
            int remove = context.query().getInt("remove", -1);
            if (add >= 0 || remove >= 0) {
                if (BasicAdminHandler.isNonceCorrect(context)) {
                    if (add >= 0) {
                        app.getSecurity().addUserToGroup((PyxisUser)user, add);
                    }
                    if (remove >= 0) {
                        app.getSecurity().removeUserFromGroup((PyxisUser)user, remove);
                    }
                } else {
                    return bah.handleInformation(context, 5, "Invalid group membership change request.");
                }
            }
            Collection<PyxisUserGroup> groups = app.getSecurity().getAllUserGroups();
            ArrayList<BasicUserGroup> myGroups = new ArrayList<BasicUserGroup>();
            int[] nArray = app.getSecurity().getGroupsForUser(user.getId());
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int groupId = nArray[n2];
                myGroups.add(bah.getUserGroup(groupId));
                ++n2;
            }
            groups.removeAll(myGroups);
            context.delivery().putObject("user", user).putObject("groups", groups).putObject("membership", myGroups).put("nonce", BasicAdminHandler.getNonce(context));
            return bah.mustache(this.getTemplateName());
        }
        return false;
    }
}

