/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.users;

import com.techempower.data.util.ObjectColumn;
import com.techempower.data.util.TabularColumn;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.BasicAdminPaging;
import com.techempower.gemini.admin.standard.users.UserCategory;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.pyxis.BasicWebUser;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class UserList
extends BasicAdminFunction {
    public static final int DEFAULT_PAGE_SIZE = 30;
    private static final List<TabularColumn> STANDARD_OBJECT_COLUMNS = new ArrayList<TabularColumn>();

    static {
        STANDARD_OBJECT_COLUMNS.add(new ObjectColumn("UserID", "getUserID", "0"));
        STANDARD_OBJECT_COLUMNS.add(new ObjectColumn("Username", "getUserUsername", ""));
        STANDARD_OBJECT_COLUMNS.add(new ObjectColumn("Email", "getUserEmail", ""));
        STANDARD_OBJECT_COLUMNS.add(new ObjectColumn("FirstName", "getUserFirstname", ""));
        STANDARD_OBJECT_COLUMNS.add(new ObjectColumn("LastName", "getUserLastname", ""));
        STANDARD_OBJECT_COLUMNS.add(new ObjectColumn("LastLogin", "getUserLastLogin", ""));
    }

    public UserList() {
        super("user-list", "List Users", "List, filter, and manage application users", "users");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        List<PyxisUser> unfilteredUsers = app.getStore().list(bah.getUserClass());
        return this.handleUserList(bah, app, log, context, unfilteredUsers);
    }

    public boolean handleUserList(BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log, Context context, List<BasicWebUser> unfilteredUsers) {
        UserCategory cat = (UserCategory)bah.getFunctionCategory("users");
        Form form = cat.buildUserListForm(app, context);
        cat.processUserListForm(context, form);
        List<BasicWebUser> users = cat.filterUsers(form, unfilteredUsers);
        int unfilteredSize = unfilteredUsers.size();
        int filteredSize = users.size();
        context.delivery().put("summary", String.valueOf(unfilteredSize == filteredSize ? "All " : "") + filteredSize + " user" + StringHelper.pluralize(filteredSize, " matches", "s match") + " the specified filters; " + unfilteredSize + " user" + StringHelper.pluralize(unfilteredSize) + " total.");
        if ("csv".equalsIgnoreCase(context.query().get("format", ""))) {
            TabularColumn[] custom = cat.getCustomUserDumpColumns();
            ArrayList<TabularColumn> fields = new ArrayList<TabularColumn>(STANDARD_OBJECT_COLUMNS.size() + custom.length);
            fields.addAll(STANDARD_OBJECT_COLUMNS);
            fields.addAll(Arrays.asList(custom));
            String filename = String.valueOf(app.getVersion().getAbbreviatedProductName()) + " Users - " + DateHelper.STANDARD_TECH_FORMAT_DATEONLY.format(new Date()) + ".csv";
            return GeminiHelper.dataDump(app, context, fields, users.iterator(), filename, log);
        }
        int currentPage = context.query().getInt("p", 1);
        String baseURL = "";
        BasicAdminPaging paging = new BasicAdminPaging(context, baseURL, users.size(), currentPage, this.getPageSize());
        List<BasicWebUser> extracted = paging.extractCurrentPage(users);
        ArrayList<UserView> views = new ArrayList<UserView>(extracted.size());
        for (BasicWebUser user : extracted) {
            views.add(new UserView(user, cat));
        }
        context.delivery().putObject("customColumns", cat.getCustomUserListColumns()).putObject("paging", paging).putObject("form", form).putObject("users", views).put("customActions", cat.getCustomUserActions().length > 0).put("customActionCount", cat.getCustomUserActions().length);
        return bah.mustache(this.getTemplateName());
    }

    protected int getPageSize() {
        return 30;
    }

    public static class UserView {
        public final int id;
        public final String username;
        public final String email;
        public final String firstName;
        public final String lastName;
        public final List<String> columns;
        public final List<String> actions;

        public UserView(BasicWebUser user, UserCategory cat) {
            TabularColumn[] customColumns = cat.getCustomUserListColumns();
            UserCategory.CustomUserAction[] customActions = cat.getCustomUserActions();
            this.id = user.getId();
            this.username = user.getUserUsername();
            this.email = user.getUserEmail();
            this.firstName = user.getUserFirstname();
            this.lastName = user.getUserLastname();
            this.columns = new ArrayList<String>(customColumns.length);
            Object[] objectArray = customColumns;
            int n = customColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TabularColumn column = objectArray[n2];
                this.columns.add(column.getValue(user));
                ++n2;
            }
            this.actions = new ArrayList<String>(customActions.length);
            objectArray = customActions;
            n = customActions.length;
            n2 = 0;
            while (n2 < n) {
                Object action = objectArray[n2];
                this.actions.add(((UserCategory.CustomUserAction)action).getValue(user));
                ++n2;
            }
        }
    }
}

