/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.annotation;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Handler;
import com.techempower.gemini.LegacyContext;
import com.techempower.gemini.annotation.Role;
import com.techempower.gemini.annotation.injector.Injector;
import com.techempower.gemini.annotation.injector.ParameterInjector;
import com.techempower.gemini.annotation.intercept.HandlerIntercept;
import com.techempower.gemini.annotation.intercept.Intercept;
import com.techempower.gemini.annotation.intercept.Require;
import com.techempower.gemini.annotation.response.HandlerResponse;
import com.techempower.gemini.annotation.response.Response;
import com.techempower.log.ComponentLog;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class AnnotationHandler
implements Handler<BasicDispatcher, LegacyContext> {
    private GeminiApplication application;
    private ComponentLog log;
    private Object handleObject;
    private Method method;
    private MethodAccess access;
    private int methodIndex;
    private Class<?> returnType;
    private String[] commands;
    private List<HandlerIntercept<BasicDispatcher, Context>> intercepts = new ArrayList<HandlerIntercept<BasicDispatcher, Context>>();
    private List<Annotation> interceptAnnotations = new ArrayList<Annotation>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private HandlerResponse<BasicDispatcher, Context> responseIntercept;
    private Annotation responseAnnotation;

    public AnnotationHandler(GeminiApplication application, BasicDispatcher dispatcher, Object handleObject, Method method, String[] commands) {
        this.application = application;
        this.log = application.getLog("hAnn");
        this.handleObject = handleObject;
        this.method = method;
        this.commands = commands;
        this.configureHandler(dispatcher);
    }

    private void configureHandler(BasicDispatcher dispatcher) {
        this.returnType = this.method.getReturnType();
        this.access = MethodAccess.get(this.handleObject.getClass());
        this.methodIndex = this.access.getIndex(this.method.getName());
        this.setParameters(dispatcher);
        this.setInterceptAnnotations(dispatcher, this.method.getDeclaringClass().getAnnotations());
        this.setInterceptAnnotations(dispatcher, this.method.getAnnotations());
        this.setResponseAnnotation(dispatcher, this.method.getAnnotations());
    }

    @Override
    public boolean acceptRequest(BasicDispatcher dispatcher, LegacyContext context, String command) {
        if (this.commands != null && this.commands.length > 0) {
            String[] stringArray = this.commands;
            int n = this.commands.length;
            int n2 = 0;
            while (n2 < n) {
                String cmd = stringArray[n2];
                if (cmd.equalsIgnoreCase(command)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean handleRequest(BasicDispatcher dispatcher, LegacyContext context, String command) {
        Object returnValue;
        int currentDispatches = context.getDispatches();
        int counter = 0;
        for (HandlerIntercept<BasicDispatcher, Context> intercept : this.intercepts) {
            if (intercept.intercept(this.method, dispatcher, context, command, this.interceptAnnotations.get(counter))) {
                return intercept.handleIntercept(this.method, dispatcher, context, command, this.interceptAnnotations.get(counter));
            }
            ++counter;
        }
        try {
            returnValue = this.access.invoke(this.handleObject, this.methodIndex, this.prepareArgs(dispatcher, context));
        }
        catch (IllegalArgumentException e) {
            this.log.log("Error: Invoking method (" + this.method.getName() + ") with incorrect arguments.");
            throw new AnnotationException((Throwable)e);
        }
        catch (Exception e) {
            throw new AnnotationException((Throwable)e);
        }
        if (context.getDispatches() != currentDispatches || context.isCommitted() || this.responseIntercept == null) {
            if (this.returnType.equals(Boolean.TYPE)) {
                return (Boolean)returnValue;
            }
            return true;
        }
        return this.responseIntercept.sendResponse(this.handleObject, this.method, dispatcher, context, command, returnValue, this.responseAnnotation);
    }

    private Object[] prepareArgs(BasicDispatcher dispatcher, Context context) {
        Object[] args = new Object[this.parameters.size()];
        int counter = 0;
        for (Parameter param : this.parameters) {
            args[counter++] = param.getObject(dispatcher, context);
        }
        return args;
    }

    private void addIntercept(BasicDispatcher dispatcher, Class<? extends HandlerIntercept<BasicDispatcher, Context>> clazz) {
        this.addIntercept(dispatcher, clazz, null);
    }

    private void addIntercept(BasicDispatcher dispatcher, Class<? extends HandlerIntercept<BasicDispatcher, Context>> clazz, Annotation annotation) {
        HandlerIntercept intercept = dispatcher.getIntercept(clazz);
        if (intercept == null) {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                if (constructor.getParameterTypes().length == 1 && GeminiApplication.class.isAssignableFrom(constructor.getParameterTypes()[0])) {
                    try {
                        intercept = (HandlerIntercept)constructor.newInstance(this.application);
                        break;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                        this.log.log("Error: Intercept (" + clazz.getName() + ") could not be created with GeminiApplication, using default constructor.");
                    }
                }
                ++n2;
            }
            if (intercept == null) {
                try {
                    intercept = clazz.newInstance();
                }
                catch (InstantiationException e) {
                    this.log.log("Error: Intercept (" + clazz.getName() + ") has not defined a default constructor.");
                }
                catch (IllegalAccessException e) {
                    this.log.log("Error: Intercept (" + clazz.getName() + ") is not a public class.");
                }
            }
            if (intercept != null) {
                if (clazz.isAnnotationPresent(Role.class)) {
                    dispatcher.addIntercept(clazz.getAnnotation(Role.class).value(), intercept);
                } else {
                    dispatcher.addIntercept(intercept);
                }
            }
        }
        if (intercept != null) {
            this.intercepts.add(intercept);
            this.interceptAnnotations.add(annotation);
        }
    }

    private void setInterceptAnnotations(BasicDispatcher dispatcher, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Intercept interceptAnnotation;
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(Require.class)) {
                Class<? extends HandlerIntercept>[] classArray = ((Require)annotation).value();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<? extends HandlerIntercept> intercept = classArray[n4];
                    this.addIntercept(dispatcher, intercept);
                    ++n4;
                }
            }
            if ((interceptAnnotation = annotation.annotationType().getAnnotation(Intercept.class)) != null) {
                this.addIntercept(dispatcher, interceptAnnotation.value(), annotation);
            }
            ++n2;
        }
    }

    private void setParameters(BasicDispatcher dispatcher) {
        Class<?>[] argumentTypes = this.method.getParameterTypes();
        Annotation[][] paramAnnotations = this.method.getParameterAnnotations();
        int count = 0;
        Class<?>[] classArray = argumentTypes;
        int n = argumentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (BasicDispatcher.class.isAssignableFrom(c)) {
                this.parameters.add(new Parameter(BasicDispatcher.class, null, null));
            } else if (Context.class.isAssignableFrom(c)) {
                this.parameters.add(new Parameter(Context.class, null, null));
            } else {
                boolean foundAnnotation = false;
                Annotation[] annotationArray = paramAnnotations[count];
                int n3 = annotationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation annotation = annotationArray[n4];
                    if (annotation != null && annotation.annotationType().isAnnotationPresent(Injector.class)) {
                        Injector injector = annotation.annotationType().getAnnotation(Injector.class);
                        Class<? extends ParameterInjector> clazz = injector.value();
                        ParameterInjector paramInjector = dispatcher.getInjector(clazz);
                        if (paramInjector == null) {
                            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
                            int n5 = constructorArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                Constructor<?> constructor = constructorArray[n6];
                                if (constructor.getParameterTypes().length == 1 && GeminiApplication.class.isAssignableFrom(constructor.getParameterTypes()[0])) {
                                    try {
                                        paramInjector = (ParameterInjector)constructor.newInstance(this.application);
                                        break;
                                    }
                                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                                        this.log.log("Error: Injector (" + clazz.getName() + ") could not be created with GeminiApplication, using default constructor.");
                                    }
                                }
                                ++n6;
                            }
                            if (paramInjector == null) {
                                try {
                                    paramInjector = clazz.newInstance();
                                }
                                catch (InstantiationException e) {
                                    this.log.log("Error: Injector (" + clazz.getName() + ") has not defined a default constructor.");
                                }
                                catch (IllegalAccessException e) {
                                    this.log.log("Error: Injector (" + clazz.getName() + ") is not a public class.");
                                }
                            }
                            if (paramInjector != null) {
                                if (paramInjector.getClass().isAnnotationPresent(Role.class)) {
                                    dispatcher.addInjector(clazz.getAnnotation(Role.class).value(), paramInjector);
                                } else {
                                    dispatcher.addInjector(paramInjector);
                                }
                            }
                        }
                        if (paramInjector != null) {
                            this.parameters.add(new Parameter(c, paramInjector, annotation));
                            foundAnnotation = true;
                            break;
                        }
                    }
                    ++n4;
                }
                if (!foundAnnotation) {
                    this.parameters.add(new Parameter(c, null, null));
                }
            }
            ++count;
            ++n2;
        }
    }

    private void setResponseAnnotation(BasicDispatcher dispatcher, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            Response theResponseAnnotation = annotation.annotationType().getAnnotation(Response.class);
            if (theResponseAnnotation != null) {
                Class<? extends HandlerResponse> clazz = theResponseAnnotation.value();
                HandlerResponse response = dispatcher.getResponse(clazz);
                if (response == null) {
                    Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
                    int n3 = constructorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Constructor<?> constructor = constructorArray[n4];
                        if (constructor.getParameterTypes().length == 1 && GeminiApplication.class.isAssignableFrom(constructor.getParameterTypes()[0])) {
                            try {
                                response = (HandlerResponse)constructor.newInstance(this.application);
                                break;
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                                this.log.log("Error: Response (" + clazz.getName() + ") could not be created with GeminiApplication, using default constructor.");
                            }
                        }
                        ++n4;
                    }
                    if (response == null) {
                        try {
                            response = clazz.newInstance();
                        }
                        catch (InstantiationException e) {
                            this.log.log("Error: Response (" + clazz.getName() + ") has not defined a default constructor.");
                        }
                        catch (IllegalAccessException e) {
                            this.log.log("Error: Response (" + clazz.getName() + ") is not a public class.");
                        }
                    }
                    if (response != null) {
                        if (clazz.isAnnotationPresent(Role.class)) {
                            dispatcher.addResponse(clazz.getAnnotation(Role.class).value(), response);
                        } else {
                            dispatcher.addResponse(response);
                        }
                    }
                }
                if (response != null) {
                    this.responseIntercept = response;
                    this.responseAnnotation = annotation;
                }
            }
            ++n2;
        }
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    private class AnnotationException
    extends RuntimeException {
        private static final long serialVersionUID = 5908268019924291717L;

        public AnnotationException(Throwable cause) {
            super(cause);
        }

        @Override
        public String getMessage() {
            if (this.getCause() == null) {
                return super.getMessage();
            }
            return this.getCause().getMessage();
        }

        @Override
        public String getLocalizedMessage() {
            if (this.getCause() == null) {
                return super.getLocalizedMessage();
            }
            return this.getCause().getLocalizedMessage();
        }

        @Override
        public void printStackTrace() {
            if (this.getCause() == null) {
                super.printStackTrace();
            }
            this.getCause().printStackTrace();
        }

        @Override
        public void printStackTrace(PrintStream s) {
            if (this.getCause() == null) {
                super.printStackTrace(s);
            }
            this.getCause().printStackTrace(s);
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            if (this.getCause() == null) {
                super.printStackTrace(s);
            }
            this.getCause().printStackTrace(s);
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            if (this.getCause() == null) {
                return super.getStackTrace();
            }
            return this.getCause().getStackTrace();
        }

        @Override
        public String toString() {
            if (this.getCause() == null) {
                return super.toString();
            }
            return this.getCause().toString();
        }
    }

    private class Parameter {
        private final Class<?> parameterType;
        private final Annotation injectorAnnotation;
        private final ParameterInjector<BasicDispatcher, Context> injector;

        public Parameter(Class<?> parameterType, ParameterInjector<BasicDispatcher, Context> injector, Annotation injectorAnnotation) {
            this.parameterType = parameterType;
            this.injectorAnnotation = injectorAnnotation;
            this.injector = injector;
        }

        public Object getObject(BasicDispatcher dispatcher, Context context) {
            if (BasicDispatcher.class.isAssignableFrom(this.parameterType)) {
                return dispatcher;
            }
            if (Context.class.isAssignableFrom(this.parameterType)) {
                return context;
            }
            if (this.injectorAnnotation != null && this.injector != null) {
                Object toReturn = null;
                toReturn = this.injector.getArgument(dispatcher, context, this.injectorAnnotation, this.parameterType);
                if (toReturn == null && this.parameterType.isPrimitive()) {
                    return this.getDefaultPrimitiveValue(this.parameterType);
                }
                return toReturn;
            }
            if (this.parameterType.isPrimitive()) {
                return this.getDefaultPrimitiveValue(this.parameterType);
            }
            return null;
        }

        private Object getDefaultPrimitiveValue(Class<?> c) {
            if (c.equals(Integer.TYPE)) {
                return 0;
            }
            if (c.equals(Long.TYPE)) {
                return 0L;
            }
            if (c.equals(Short.TYPE)) {
                return 0;
            }
            if (c.equals(Byte.TYPE)) {
                return 0;
            }
            if (c.equals(Float.TYPE)) {
                return Float.valueOf(0.0f);
            }
            if (c.equals(Double.TYPE)) {
                return 0.0;
            }
            if (c.equals(Character.TYPE)) {
                return Character.valueOf('\u0000');
            }
            if (c.equals(Boolean.TYPE)) {
                return false;
            }
            return null;
        }
    }
}

