/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.annotation.injector;

import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.Context;
import com.techempower.gemini.annotation.injector.Param;
import com.techempower.gemini.annotation.injector.ParameterInjector;
import java.lang.annotation.Annotation;

public class ParamInjector<D extends BasicDispatcher, C extends Context>
implements ParameterInjector<D, C> {
    @Override
    public Object getArgument(D dispatcher, C context, Annotation annotation, Class<?> c) {
        Param p = (Param)annotation;
        return this.getType(c, p.value(), p.defaultValue(), context);
    }

    private Object getType(Class<?> c, String key, String defaultValue, C context) {
        if (c.equals(String.class)) {
            return ((Context)context).query().get(key, defaultValue);
        }
        if (c.equals(Integer.TYPE) || c.equals(Integer.class)) {
            try {
                return ((Context)context).query().getInt(key, Integer.parseInt(defaultValue));
            }
            catch (Exception e) {
                return ((Context)context).query().getInt(key);
            }
        }
        if (c.equals(Double.TYPE) || c.equals(Double.class)) {
            try {
                return ((Context)context).query().getDouble(key, Double.parseDouble(defaultValue));
            }
            catch (Exception e) {
                return ((Context)context).query().getDouble(key);
            }
        }
        if (c.equals(Boolean.TYPE) || c.equals(Boolean.class)) {
            try {
                return ((Context)context).query().getBoolean(key, Boolean.parseBoolean(defaultValue));
            }
            catch (Exception e) {
                return ((Context)context).query().getBoolean(key, false);
            }
        }
        if (c.equals(Long.TYPE) || c.equals(Long.class)) {
            try {
                return ((Context)context).query().getLong(key, Long.parseLong(defaultValue));
            }
            catch (Exception e) {
                return ((Context)context).query().getLong(key);
            }
        }
        return null;
    }
}

