/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster;

import com.techempower.gemini.cluster.Message;
import com.techempower.gemini.cluster.RequestMessage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class MessageQueue {
    public static final int DEFAULT_QUEUE_SIZE_LIMIT = 25000;
    private final ConcurrentLinkedQueue<Message> queue;
    private final AtomicInteger size;
    private final int sizeLimit;
    private long lastCheck = System.currentTimeMillis();
    private long lastAdd = System.currentTimeMillis();

    public MessageQueue(int sizeLimit) {
        this.queue = new ConcurrentLinkedQueue();
        this.size = new AtomicInteger();
        this.sizeLimit = sizeLimit;
    }

    public MessageQueue() {
        this(25000);
    }

    public Message peek() {
        this.lastCheck = System.currentTimeMillis();
        return this.queue.peek();
    }

    public Message poll() {
        Message toReturn = this.queue.poll();
        if (toReturn != null) {
            this.size.decrementAndGet();
        }
        this.lastCheck = System.currentTimeMillis();
        return toReturn;
    }

    public void discardFirstAndAdd(Message message) {
        Message first = this.queue.poll();
        if (first != null) {
            this.size.decrementAndGet();
        }
        this.addDirectly(message);
    }

    public void addDirectly(Message message) {
        this.queue.add(message);
        this.size.incrementAndGet();
        this.lastAdd = System.currentTimeMillis();
    }

    public void add(Message message) {
        long now = System.currentTimeMillis();
        if (message instanceof RequestMessage) {
            RequestMessage rm = (RequestMessage)message;
            if (this.getLastCheck() + rm.getRequestTimeout() >= now) {
                this.addDirectly(message);
            }
        } else if (this.size() >= this.sizeLimit) {
            this.discardFirstAndAdd(message);
        } else {
            this.addDirectly(message);
        }
    }

    public int size() {
        return this.size.get();
    }

    public long getLastCheck() {
        return this.lastCheck;
    }

    public long getLastAdd() {
        return this.lastAdd;
    }
}

