/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster;

import com.techempower.gemini.cluster.Message;

public class RequestMessage
extends Message {
    public static final long DEFAULT_REQUEST_TIMEOUT = 10000L;
    private transient long requestTimeout = 10000L;
    private transient long sentTime = 0L;
    private transient int expectedResponseCount = 1;

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void captureSentTime() {
        this.sentTime = System.currentTimeMillis();
    }

    public long getRequestTimeoutRemaining() {
        if (this.sentTime == 0L) {
            return 0L;
        }
        long remaining = this.sentTime + this.getRequestTimeout() - System.currentTimeMillis();
        return remaining > 0L ? remaining : 0L;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getExpectedResponseCount() {
        return this.expectedResponseCount;
    }

    public void setExpectedResponseCount(int expected) {
        this.expectedResponseCount = expected;
    }
}

