/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.client.handler;

import com.techempower.gemini.Configurator;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.cluster.client.ClusterClient;
import com.techempower.gemini.cluster.client.MessageHandler;
import com.techempower.gemini.cluster.message.ConfigurationRequest;
import com.techempower.gemini.cluster.message.ConfigurationResponse;
import com.techempower.gemini.configuration.ConfigurationProvider;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import java.util.Map;

public class ClientConfigurationHandler
implements MessageHandler<ConfigurationResponse>,
ConfigurationProvider {
    public static final String COMPONENT_CODE = "cHcf";
    private final GeminiApplication application;

    public ClientConfigurationHandler(GeminiApplication application) {
        this.application = application;
    }

    @Override
    public Class<ConfigurationResponse> getMessageClass() {
        return ConfigurationResponse.class;
    }

    @Override
    public boolean requiresSeparateThread() {
        return false;
    }

    @Override
    public void handle(ConfigurationResponse message) {
    }

    @Override
    public void configure(EnhancedProperties props) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean load(GeminiApplication app, ComponentLog l, EnhancedProperties props) {
        ClusterClient client = this.application.getClusterClient();
        if (client == null) return false;
        if (!client.isEnabled()) {
            client.configure(app.getServletConfig());
        }
        if (client.isEnabled()) {
            client.begin();
            l.log("Fetching configuration from cluster master.");
            try {
                ConfigurationRequest request = new ConfigurationRequest();
                request.machineName = Configurator.getMachineName();
                ConfigurationResponse response = (ConfigurationResponse)client.sendRequest(request);
                if (response == null) return false;
                props.putAll((Map<?, ?>)response.getProperties());
                l.log("Successfully fetched configuration from cluster master.");
                return true;
            }
            catch (Exception exc) {
                l.log("Exception while fetching configuration from cluster master: " + exc);
                return false;
            }
        } else {
            l.log("Configuration by cluster master is disabled.");
        }
        return false;
    }
}

