/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.message;

import com.techempower.gemini.cluster.ClusterConstants;
import com.techempower.gemini.cluster.ResponseMessage;
import com.techempower.gemini.cluster.server.ServerConnection;
import com.techempower.helper.DateHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClusterStatusResponse
extends ResponseMessage {
    public List<NodeStatus> nodes;

    @Override
    public String toString() {
        return "ClusterStatusResponse [" + this.nodes + "]";
    }

    public void buildNodeList(Iterator<ServerConnection> connections) {
        this.nodes = new ArrayList<NodeStatus>();
        while (connections.hasNext()) {
            this.nodes.add(new NodeStatus(connections.next()));
        }
    }

    public static class NodeStatus {
        public int nodeId;
        public int channel;
        public long connectionTime;
        public long elapsedTime;
        public long messageCount;
        public String name;
        public String description;

        public NodeStatus() {
        }

        public NodeStatus(ServerConnection sc) {
            long now = System.currentTimeMillis();
            this.nodeId = sc.getNode();
            this.channel = sc.getChannel();
            this.connectionTime = sc.getConnectionTime();
            this.elapsedTime = now - this.connectionTime;
            this.messageCount = sc.getMessageCount();
            this.name = sc.getClientName();
            this.description = sc.getClientDescription();
        }

        public String toString() {
            return "[Node " + this.nodeId + "; " + this.channel + "; " + this.name + "; " + this.connectionTime + "ms" + "; " + this.messageCount + "msgs" + "; " + this.description + "]";
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getChannel() {
            return this.channel;
        }

        public String getChannelName() {
            return String.valueOf(this.channel) + " (" + ClusterConstants.channelName(this.channel) + ")";
        }

        public long getConnectionTime() {
            return this.connectionTime;
        }

        public long getMessageCount() {
            return this.messageCount;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public String getHumanElapsedTime() {
            return DateHelper.getHumanDuration(this.elapsedTime, 2);
        }
    }
}

