/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.server;

import com.techempower.TechEmpowerApplication;
import com.techempower.Version;
import com.techempower.asynchronous.Asynchronous;
import com.techempower.gemini.cluster.server.ConfigurationException;
import com.techempower.gemini.cluster.server.Master;
import com.techempower.gemini.cluster.server.MasterUtilities;
import com.techempower.gemini.cluster.server.ShutdownThread;
import com.techempower.scheduler.Scheduler;
import com.techempower.util.EnhancedProperties;
import java.io.File;

public class MasterApplication
extends TechEmpowerApplication
implements Asynchronous {
    private final Master master;

    public MasterApplication() {
        this.getComponentLog().log(this.getVersion().getNameAndDeployment());
        this.master = new Master(this);
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
    }

    public void configure(File file) throws ConfigurationException {
        EnhancedProperties props = MasterUtilities.readConfigurationFile(file);
        this.master.configure(props);
    }

    @Override
    protected Version constructVersion() {
        return new Version(){

            @Override
            public int getMajorVersion() {
                return 1;
            }

            @Override
            public int getMinorVersion() {
                return 0;
            }

            @Override
            public int getMicroVersion() {
                return 0;
            }

            @Override
            public String getAbbreviatedProductName() {
                return "Master";
            }

            @Override
            public String getDeveloperName() {
                return "TechEmpower";
            }

            @Override
            public String getProductCode() {
                return "CL";
            }

            @Override
            public String getProductName() {
                return "Cluster Master";
            }
        };
    }

    @Override
    protected Scheduler constructScheduler() {
        return null;
    }

    @Override
    public void begin() {
        this.master.begin();
    }

    @Override
    public void end() {
        this.stopAsynchronousResources();
        this.master.end();
    }

    public static void main(String[] args) {
        File configurationFile;
        MasterApplication.debug("");
        MasterApplication.debug("Gemini Cluster Master");
        String configurationFilename = "master.conf";
        if (args.length == 1) {
            configurationFilename = args[0];
        }
        if ((configurationFile = new File(configurationFilename)).exists()) {
            MasterApplication master = null;
            MasterApplication.debug("Configuration file: " + configurationFilename);
            MasterApplication.debug("");
            try {
                master = new MasterApplication();
                master.configure(configurationFile);
                master.begin();
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (ConfigurationException exc) {
                MasterApplication.debug("Configuration exception: " + exc);
                MasterApplication.debug("Cause: " + exc.getCause());
            }
            catch (Exception exc) {
                MasterApplication.debug("Exception: " + exc);
                MasterApplication.debug("Stopping application.");
            }
            if (master != null) {
                master.end();
            }
        } else {
            MasterApplication.debug("Configuration file not found:");
            MasterApplication.debug(configurationFile.getAbsolutePath());
            MasterApplication.debug("");
            MasterApplication.debug("Usage:");
            MasterApplication.debug("  java -jar master.jar [configuration-file]");
        }
    }

    public static void debug(String output) {
        System.out.println(output);
    }

    protected Master getMaster() {
        return this.master;
    }
}

