/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.server.handler;

import com.techempower.gemini.cluster.message.AuthenticationRequest;
import com.techempower.gemini.cluster.message.AuthenticationResponse;
import com.techempower.gemini.cluster.server.ClusterHandler;
import com.techempower.gemini.cluster.server.Master;
import com.techempower.gemini.cluster.server.ServerConnection;
import com.techempower.helper.StringHelper;
import com.techempower.util.EnhancedProperties;

public class AuthenticationHandler
implements ClusterHandler<AuthenticationRequest> {
    private String key;

    @Override
    public Class<AuthenticationRequest> getMessageClass() {
        return AuthenticationRequest.class;
    }

    @Override
    public void handle(ServerConnection client, AuthenticationRequest request, Master master) {
        AuthenticationResponse response = new AuthenticationResponse();
        if (StringHelper.equals(request.getKey(), this.key)) {
            client.setAuthenticated(true);
            client.setDescription(request.getDeploymentDescription());
            client.setChannel(request.getChannel());
            master.getChannels().add(client);
            response.setStatus(0);
            response.setNodeId(client.getNode());
        } else {
            response.setStatus(1);
        }
        master.sendResponse(client, request, response);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.key = props.getProperty("Master.Authentication.Key", "dev");
    }

    @Override
    public boolean requiresAuthentication() {
        return false;
    }

    @Override
    public boolean requiresSeparateThread() {
        return false;
    }
}

