/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.transport.kryonet;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryonet.Client;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.minlog.Log;
import com.techempower.TechEmpowerApplication;
import com.techempower.gemini.cluster.Message;
import com.techempower.gemini.cluster.client.ClientTransport;
import com.techempower.gemini.cluster.client.ClusterClientCallback;
import com.techempower.gemini.cluster.transport.kryonet.KryoHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import java.io.IOException;

public class KryoClientTransport
implements ClientTransport {
    public static final int DEFAULT_TIMEOUT_MS = 5000;
    public static final int DEFAULT_TCP_PORT = 54555;
    public static final int DEFAULT_OUTPUT_BUFFER = 32768;
    public static final int DEFAULT_OBJECT_BUFFER = 16384;
    private final ComponentLog log;
    private final Client client;
    private ClusterClientCallback callback;
    private int timeout = 5000;
    private String host = null;
    private int tcpPort = 54555;

    public KryoClientTransport(TechEmpowerApplication application) {
        this.log = application.getLog("KryC");
        Log.setLogger((Log.Logger)new Log.Logger(){

            public void log(int level, String category, String message, Throwable ex) {
                KryoClientTransport.this.log.log("[" + category + "] " + message, level, ex);
            }
        });
        this.client = new Client(32768, 16384);
        Kryo kryo = this.client.getKryo();
        KryoHelper.setupSerialization(kryo);
        this.client.addListener(new Listener(){

            public void received(Connection connection, Object object) {
                if (object instanceof Message) {
                    Message message = (Message)object;
                    if (KryoClientTransport.this.callback != null) {
                        KryoClientTransport.this.callback.process(message);
                    }
                }
            }
        });
    }

    @Override
    public void configure(EnhancedProperties props) {
        String propsPrefix = "Kryo.Client.";
        this.timeout = props.getIntegerProperty(String.valueOf(propsPrefix) + "Timeout", this.timeout);
        this.host = props.getProperty(String.valueOf(propsPrefix) + "Host", this.host);
        this.tcpPort = props.getIntegerProperty(String.valueOf(propsPrefix) + "TcpPort", this.tcpPort);
        this.log.log("KryoClientTransport configured: [timeout=" + this.timeout + ", host=\"" + this.host + "\", tcpPort=\"" + this.tcpPort + "]", 10);
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public boolean connect() {
        this.client.start();
        try {
            this.client.connect(this.timeout, this.host, this.tcpPort);
            return true;
        }
        catch (IOException e) {
            this.log.log("Exception connecting to server.", 70, e);
            return false;
        }
    }

    @Override
    public void setCallback(ClusterClientCallback callback) {
        this.callback = callback;
    }

    @Override
    public void send(Message message) {
        this.client.sendTCP((Object)message);
    }

    @Override
    public void disconnect() {
        this.log.log("Disconnecting from server.");
        this.client.close();
    }

    @Override
    public String getTransportName() {
        return "KryoNet Transport";
    }
}

