/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.transport.kryonet;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.Server;
import com.esotericsoftware.minlog.Log;
import com.techempower.TechEmpowerApplication;
import com.techempower.gemini.cluster.Message;
import com.techempower.gemini.cluster.server.Master;
import com.techempower.gemini.cluster.server.ServerConnection;
import com.techempower.gemini.cluster.server.ServerTransport;
import com.techempower.gemini.cluster.transport.kryonet.KryoConnection;
import com.techempower.gemini.cluster.transport.kryonet.KryoHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class KryoServerTransport
implements ServerTransport {
    private final ComponentLog log;
    private final Server server;
    private final Map<Integer, ServerConnection> connections = new ConcurrentHashMap<Integer, ServerConnection>();
    private Master master;
    private int tcpPort = 54555;

    public KryoServerTransport(TechEmpowerApplication application) {
        this.log = application.getLog("KryS");
        Log.setLogger((Log.Logger)new Log.Logger(){

            public void log(int level, String category, String message, Throwable ex) {
                KryoServerTransport.this.log.log("[" + category + "] " + message, level, ex);
            }
        });
        this.server = new Server(32768, 16384);
        Kryo kryo = this.server.getKryo();
        KryoHelper.setupSerialization(kryo);
        this.server.addListener((Listener)new KryoServerListener());
    }

    protected ServerConnection getServerConnection(Connection connection) {
        ServerConnection client = this.connections.get(connection.getID());
        if (client == null) {
            client = new KryoConnection(connection);
            this.connections.put(connection.getID(), client);
        }
        return client;
    }

    protected void removeServerConnection(Connection connection) {
        this.connections.remove(connection.getID());
    }

    @Override
    public Iterator<ServerConnection> getConnections() {
        return this.connections.values().iterator();
    }

    @Override
    public void configure(EnhancedProperties props) {
        String propsPrefix = "Kryo.Server.";
        this.tcpPort = props.getIntegerProperty(String.valueOf(propsPrefix) + "TcpPort", this.tcpPort);
        this.log.log("KryoServerTransport configured: [tcpPort=" + this.tcpPort + "]", 10);
    }

    @Override
    public void send(Message message, Set<ServerConnection> destinationNodes) {
        if (message.getExclusiveConnection() != null) {
            KryoConnection kc = (KryoConnection)message.getExclusiveConnection();
            this.server.sendToTCP(kc.getConnection().getID(), (Object)message);
        } else if (destinationNodes == null) {
            if (message.getOmittedConnection() != null) {
                KryoConnection kc = (KryoConnection)message.getOmittedConnection();
                this.server.sendToAllExceptTCP(kc.getConnection().getID(), (Object)message);
            } else {
                this.server.sendToAllTCP((Object)message);
            }
        } else {
            for (ServerConnection connection : destinationNodes) {
                KryoConnection dest = (KryoConnection)connection;
                if (dest == message.getOmittedConnection()) continue;
                this.server.sendToTCP(dest.getConnection().getID(), (Object)message);
            }
        }
    }

    @Override
    public void begin() {
        this.server.start();
        try {
            this.server.bind(this.tcpPort);
        }
        catch (IOException e) {
            this.log.log("Exception starting server.", 70, e);
        }
    }

    @Override
    public void end() {
        this.server.stop();
    }

    @Override
    public void setMaster(Master master) {
        this.master = master;
    }

    @Override
    public String getTransportName() {
        return "KryoNet Transport";
    }

    class KryoServerListener
    extends Listener {
        KryoServerListener() {
        }

        public void received(Connection connection, Object object) {
            if (object instanceof Message) {
                Message message = (Message)object;
                ServerConnection client = KryoServerTransport.this.getServerConnection(connection);
                KryoServerTransport.this.master.process(client, message);
            }
        }

        public void disconnected(Connection connection) {
            ServerConnection client = KryoServerTransport.this.getServerConnection(connection);
            KryoServerTransport.this.master.disconnect(client);
            KryoServerTransport.this.removeServerConnection(connection);
        }
    }
}

