/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.context;

import com.techempower.gemini.Context;
import com.techempower.gemini.Cookie;
import com.techempower.gemini.ResponseCookie;
import com.techempower.helper.StringHelper;

public class Cookies {
    private final Context context;

    public Cookies(Context context) {
        this.context = context;
    }

    public <C extends Cookie> C get(String name) {
        return this.context.getRequest().getCookie(name);
    }

    public String getValue(String name) {
        Object returnedCookie = this.get(name);
        return returnedCookie != null ? returnedCookie.getValue() : null;
    }

    public boolean test(String name, String value) {
        return StringHelper.equals(value, this.getValue(name));
    }

    public Cookies remove(String name) {
        this.remove(name, this.context.getInfrastructure().getUrl());
        return this;
    }

    public Cookies remove(String name, String path) {
        this.context.getRequest().deleteCookie(name, path);
        return this;
    }

    public Cookies put(ResponseCookie responseCookie) {
        this.context.getRequest().setCookie(responseCookie.getName(), responseCookie.getValue(), responseCookie.getPath(), responseCookie.getAge(), responseCookie.isSecure());
        return this;
    }
}

