/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.context;

import com.techempower.collection.MutableNamedValues;
import com.techempower.gemini.Context;
import com.techempower.gemini.session.Session;
import com.techempower.helper.NumberHelper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class SessionNamedValues
implements MutableNamedValues {
    private final Context context;

    public SessionNamedValues(Context context) {
        this.context = context;
    }

    @Override
    public boolean has(String name) {
        Session currentSession = this.context.getSession(false);
        return currentSession != null && currentSession.getAttribute(name) != null;
    }

    @Override
    public Set<String> names() {
        HashSet<String> toReturn = new HashSet<String>();
        Session currentSession = this.context.getSession(false);
        if (currentSession != null) {
            Enumeration<String> attributeNames = currentSession.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                toReturn.add(attributeNames.nextElement());
            }
        }
        return toReturn;
    }

    public <O> O getObject(String name, O defaultValue) {
        Session currentSession = this.context.getSession(false);
        Object obj = currentSession != null ? currentSession.getAttribute(name) : null;
        return (O)(obj != null ? obj : defaultValue);
    }

    public <O> O getObject(String name) {
        return this.getObject(name, null);
    }

    public SessionNamedValues putObject(String name, Object value) {
        this.context.getSession(true).setAttribute(name, value);
        return this;
    }

    @Override
    public String get(String name) {
        return this.get(name, null);
    }

    @Override
    public String get(String name, String defaultValue) {
        Session session = this.context.getSession(false);
        if (session != null) {
            try {
                String value = (String)session.getAttribute(name);
                if (value != null) {
                    return value;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        Session session = this.context.getSession(false);
        if (session != null) {
            try {
                Integer value = (Integer)session.getAttribute(name);
                if (value != null) {
                    return value;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public int getInt(String name, int defaultValue, int minimum, int maximum) {
        return NumberHelper.boundInteger(this.getInt(name, defaultValue), minimum, maximum);
    }

    @Override
    public long getLong(String name, long defaultValue, long minimum, long maximum) {
        return NumberHelper.boundLong(this.getLong(name, defaultValue), minimum, maximum);
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        Session session = this.context.getSession(false);
        if (session != null) {
            try {
                Long value = (Long)session.getAttribute(name);
                if (value != null) {
                    return value;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        Session session = this.context.getSession(false);
        if (session != null) {
            try {
                Boolean value = (Boolean)session.getAttribute(name);
                if (value != null) {
                    return value;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public MutableNamedValues put(String name, String value) {
        return this.putObject(name, value);
    }

    @Override
    public MutableNamedValues put(String name, int value) {
        return this.putObject(name, value);
    }

    @Override
    public MutableNamedValues put(String name, long value) {
        return this.putObject(name, value);
    }

    @Override
    public MutableNamedValues put(String name, boolean value) {
        return this.putObject(name, value);
    }

    @Override
    public MutableNamedValues remove(String name) {
        Session session = this.context.getSession(false);
        if (session != null) {
            session.removeAttribute(name);
        }
        return this;
    }

    @Override
    public MutableNamedValues clear() {
        Session session = this.context.getSession(false);
        if (session != null) {
            Enumeration<String> names = session.getAttributeNames();
            ArrayList<String> toRemove = new ArrayList<String>();
            while (names.hasMoreElements()) {
                toRemove.add(names.nextElement());
            }
            for (String name : toRemove) {
                session.removeAttribute(name);
            }
        }
        return this;
    }

    public SessionNamedValues invalidate() {
        Session session = this.context.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        return this;
    }
}

